/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.FacetsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneBucketAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.data.Range;

public class LuceneNumericRangeAggregation<F, E extends Number, K>
extends AbstractLuceneBucketAggregation<Range<K>, Long> {
    private final AbstractLuceneNumericFieldCodec<?, E> codec;
    private final List<Range<K>> rangesInOrder;
    private final List<Range<E>> encodedRangesInOrder;

    private LuceneNumericRangeAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.codec = builder.codec;
        this.rangesInOrder = builder.rangesInOrder;
        this.encodedRangesInOrder = builder.encodedRangesInOrder;
    }

    @Override
    public LuceneSearchAggregation.Extractor<Map<Range<K>, Long>> request(AggregationRequestContext context) {
        context.requireCollector(FacetsCollectorFactory.INSTANCE);
        return new LuceneNumericRangeAggregationExtractor();
    }

    public static class Builder<F, E extends Number, K>
    extends AbstractLuceneBucketAggregation.AbstractBuilder<Range<K>, Long>
    implements RangeAggregationBuilder<K> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final Function<K, E> convertAndEncode;
        private final List<Range<K>> rangesInOrder = new ArrayList<Range<K>>();
        private final List<Range<E>> encodedRangesInOrder = new ArrayList<Range<E>>();

        public Builder(AbstractLuceneNumericFieldCodec<F, E> codec, Function<K, E> convertAndEncode, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(scope, field);
            this.codec = codec;
            this.convertAndEncode = convertAndEncode;
        }

        public void range(Range<? extends K> range) {
            this.rangesInOrder.add(range.map(Function.identity()));
            this.encodedRangesInOrder.add(range.map(this.convertAndEncode));
        }

        @Override
        public LuceneNumericRangeAggregation<F, E, K> build() {
            return new LuceneNumericRangeAggregation(this);
        }
    }

    private class LuceneNumericRangeAggregationExtractor
    implements LuceneSearchAggregation.Extractor<Map<Range<K>, Long>> {
        private LuceneNumericRangeAggregationExtractor() {
        }

        @Override
        public Map<Range<K>, Long> extract(AggregationExtractContext context) throws IOException {
            LuceneNumericDomain numericDomain = LuceneNumericRangeAggregation.this.codec.getDomain();
            FacetsCollector facetsCollector = context.getFacets(FacetsCollectorFactory.KEY);
            NestedDocsProvider nestedDocsProvider = LuceneNumericRangeAggregation.this.createNestedDocsProvider(context);
            Facets facetsCount = numericDomain.createRangeFacetCounts(LuceneNumericRangeAggregation.this.absoluteFieldPath, facetsCollector, LuceneNumericRangeAggregation.this.encodedRangesInOrder, nestedDocsProvider);
            FacetResult facetResult = facetsCount.getTopChildren(LuceneNumericRangeAggregation.this.rangesInOrder.size(), LuceneNumericRangeAggregation.this.absoluteFieldPath, new String[0]);
            LinkedHashMap result = new LinkedHashMap();
            for (int i = 0; i < LuceneNumericRangeAggregation.this.rangesInOrder.size(); ++i) {
                result.put(LuceneNumericRangeAggregation.this.rangesInOrder.get(i), (long)((Integer)facetResult.labelValues[i].value));
            }
            return result;
        }
    }

    public static class TypeSelector<F, E extends Number>
    implements RangeAggregationBuilder.TypeSelector {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<F> field;

        private TypeSelector(AbstractLuceneNumericFieldCodec<F, E> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <K> Builder<F, ?, K> type(Class<K> expectedType, ValueModel valueModel) {
            return new Builder<F, E, K>(this.codec, this.field.encodingContext().encoder(this.scope, this.field, this.codec, expectedType, valueModel), this.scope, this.field);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<RangeAggregationBuilder.TypeSelector, F, AbstractLuceneNumericFieldCodec<F, ?>> {
        public Factory(AbstractLuceneNumericFieldCodec<F, ?> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?, ?> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new TypeSelector((AbstractLuceneNumericFieldCodec)this.codec, scope, field);
        }
    }
}

