/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationTypeKeys;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.backend.lucene.search.sort.impl.SortTypeKeys;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNumericTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBooleanFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericMatchPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericRangePredicate;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneStandardFieldSort;
import org.hibernate.search.engine.backend.types.Sortable;

class LuceneBooleanIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneBooleanIndexFieldTypeOptionsStep, Boolean> {
    private Sortable sortable = Sortable.DEFAULT;

    LuceneBooleanIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, Boolean.class);
    }

    public LuceneBooleanIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this.thisAsS();
    }

    @Override
    public LuceneIndexValueFieldType<Boolean> toIndexFieldType() {
        boolean resolvedSearchable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedSortable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedAggregable = LuceneBooleanIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        Indexing indexing = resolvedSearchable ? Indexing.ENABLED : Indexing.DISABLED;
        DocValues docValues = resolvedSortable || resolvedAggregable ? DocValues.ENABLED : DocValues.DISABLED;
        Storage storage = resolvedProjectable ? Storage.ENABLED : Storage.DISABLED;
        LuceneBooleanFieldCodec codec = new LuceneBooleanFieldCodec(indexing, docValues, storage, (Boolean)this.indexNullAsValue);
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new LuceneNumericMatchPredicate.Factory<Boolean, Integer>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new LuceneNumericRangePredicate.Factory<Boolean, Integer>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, DocValues.ENABLED.equals((Object)docValues) ? new LuceneExistsPredicate.DocValuesBasedFactory() : new LuceneExistsPredicate.DefaultFactory());
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new LuceneStandardFieldSort.NumericFieldFactory<Boolean, Integer>(codec));
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<Boolean>(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new LuceneNumericTermsAggregation.Factory<Boolean>(codec));
        }
        return this.builder.build();
    }

    @Override
    protected LuceneBooleanIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }
}

