/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConfiguredConstraint<A extends Annotation, L extends ConstraintLocation> {
    private static final Log log = LoggerFactory.make();
    private final ConstraintDefAccessor<A> constraint;
    private final L location;

    private ConfiguredConstraint(ConstraintDef<?, A> constraint, L location) {
        this.constraint = new ConstraintDefAccessor(constraint);
        this.location = location;
    }

    public static <A extends Annotation> ConfiguredConstraint<A, BeanConstraintLocation> forType(ConstraintDef<?, A> constraint, Class<?> beanType) {
        return new ConfiguredConstraint<A, BeanConstraintLocation>(constraint, new BeanConstraintLocation(beanType));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, BeanConstraintLocation> forProperty(ConstraintDef<?, A> constraint, Member member) {
        return new ConfiguredConstraint<A, BeanConstraintLocation>(constraint, new BeanConstraintLocation(member));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, ExecutableConstraintLocation> forParameter(ConstraintDef<?, A> constraint, ExecutableElement executable, int parameterIndex) {
        return new ConfiguredConstraint<A, ExecutableConstraintLocation>(constraint, new ExecutableConstraintLocation(executable, (Integer)parameterIndex));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, ExecutableConstraintLocation> forExecutable(ConstraintDef<?, A> constraint, ExecutableElement executable) {
        return new ConfiguredConstraint<A, ExecutableConstraintLocation>(constraint, new ExecutableConstraintLocation(executable));
    }

    public ConstraintDef<?, A> getConstraint() {
        return this.constraint;
    }

    public L getLocation() {
        return this.location;
    }

    public Class<A> getConstraintType() {
        return ((ConstraintDefAccessor)this.constraint).getConstraintType();
    }

    public Map<String, Object> getParameters() {
        return ((ConstraintDefAccessor)this.constraint).getParameters();
    }

    public A createAnnotationProxy() {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(this.getConstraintType());
        for (Map.Entry<String, Object> parameter : this.getParameters().entrySet()) {
            annotationDescriptor.setValue(parameter.getKey(), parameter.getValue());
        }
        try {
            return AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
    }

    public String toString() {
        return this.constraint.toString();
    }

    private static class ConstraintDefAccessor<A extends Annotation>
    extends ConstraintDef<ConstraintDefAccessor<A>, A> {
        private ConstraintDefAccessor(ConstraintDef<?, A> original) {
            super(original);
        }

        private Class<A> getConstraintType() {
            return this.constraintType;
        }

        private Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

