/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.hibernate.validator.ap.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.util.CollectionHelper;

public class GetterCheck
extends AbstractConstraintCheck {
    private final boolean methodConstraintsSupported;

    public GetterCheck(boolean methodConstraintsSupported) {
        this.methodConstraintsSupported = methodConstraintsSupported;
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        if (!this.methodConstraintsSupported && !this.isGetterMethod(element)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "ONLY_GETTERS_MAY_BE_ANNOTATED", new Object[0]));
        }
        return Collections.emptySet();
    }

    private boolean isGetterMethod(ExecutableElement method) {
        return this.isJavaBeanGetterName(method.getSimpleName().toString()) && !this.hasParameters(method) && this.hasReturnValue(method);
    }

    private boolean hasReturnValue(ExecutableElement method) {
        return method.getReturnType().getKind() != TypeKind.VOID;
    }

    private boolean hasParameters(ExecutableElement method) {
        return !method.getParameters().isEmpty();
    }

    private boolean isJavaBeanGetterName(String methodName) {
        return methodName.startsWith("is") || methodName.startsWith("has") || methodName.startsWith("get");
    }
}

