/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.codec.WktDecoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.postgresql.util.PGobject;

public class PGGeometryTypeDescriptor
implements SqlTypeDescriptor {
    private final Wkb.Dialect wkbDialect;
    public static final PGGeometryTypeDescriptor INSTANCE_WKB_1 = new PGGeometryTypeDescriptor(Wkb.Dialect.POSTGIS_EWKB_1);
    public static final PGGeometryTypeDescriptor INSTANCE_WKB_2 = new PGGeometryTypeDescriptor(Wkb.Dialect.POSTGIS_EWKB_2);

    private PGGeometryTypeDescriptor(Wkb.Dialect dialect) {
        this.wkbDialect = dialect;
    }

    public Geometry<?> toGeometry(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PGobject) {
            String pgValue = ((PGobject)object).getValue();
            assert (pgValue != null);
            if (pgValue.startsWith("00") || pgValue.startsWith("01")) {
                ByteBuffer buffer = ByteBuffer.from((String)pgValue);
                WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)this.wkbDialect);
                return decoder.decode(buffer);
            }
            return PGGeometryTypeDescriptor.parseWkt(pgValue);
        }
        throw new IllegalStateException("Received object of type " + object.getClass().getCanonicalName());
    }

    private static Geometry<?> parseWkt(String pgValue) {
        WktDecoder decoder = Wkt.newDecoder((Wkt.Dialect)Wkt.Dialect.POSTGIS_EWKT_1);
        return decoder.decode(pgValue);
    }

    public int getSqlType() {
        return 5432;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new ValueBinder<X>(){

            public void bind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (value == null) {
                    st.setNull(index, 1111);
                } else {
                    this.doBind(st, value, index, options);
                }
            }

            public void bind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (value == null) {
                    st.setNull(name, 1111);
                } else {
                    this.doBind(st, value, name, options);
                }
            }

            private void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                PGobject obj = this.toPGobject(value, options);
                st.setObject(index, obj);
            }

            private void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                PGobject obj = this.toPGobject(value, options);
                st.setObject(name, (Object)obj);
            }

            private PGobject toPGobject(X value, WrapperOptions options) throws SQLException {
                WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)PGGeometryTypeDescriptor.this.wkbDialect);
                Geometry geometry = (Geometry)javaTypeDescriptor.unwrap(value, Geometry.class, options);
                String hexString = encoder.encode(geometry, ByteOrder.NDR).toString();
                PGobject obj = new PGobject();
                obj.setType("geometry");
                obj.setValue(hexString);
                return obj;
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(PGGeometryTypeDescriptor.this.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(PGGeometryTypeDescriptor.this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(PGGeometryTypeDescriptor.this.toGeometry(statement.getObject(name)), options);
            }
        };
    }
}

