/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.type.Type;

public class SpatialProjections {
    private SpatialProjections() {
    }

    public static Projection extent(final String propertyName) {
        return new SimpleProjection(){

            public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
                return new Type[]{criteriaQuery.getType(criteria, propertyName)};
            }

            public String toSqlString(Criteria criteria, int position, CriteriaQuery criteriaQuery) throws HibernateException {
                StringBuilder stbuf = new StringBuilder();
                SessionFactoryImplementor factory = criteriaQuery.getFactory();
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, propertyName);
                Dialect dialect = factory.getDialect();
                if (dialect instanceof SpatialDialect) {
                    SpatialDialect seDialect = (SpatialDialect)dialect;
                    stbuf.append(seDialect.getSpatialAggregateSQL(columns[0], 1));
                    stbuf.append(" as y").append(position).append('_');
                    return stbuf.toString();
                }
                return null;
            }
        };
    }
}

