/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextualExceptionBridge
implements FieldBridge {
    private FieldBridge delegate;
    protected Class<?> clazz;
    protected List<XMember> path = new LinkedList<XMember>();
    protected String fieldName;

    public ContextualExceptionBridge setFieldBridge(FieldBridge delegate) {
        this.delegate = delegate;
        return this;
    }

    public ContextualExceptionBridge setClass(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public ContextualExceptionBridge setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    protected BridgeException buildBridgeException(Exception e, String method) {
        StringBuilder error = new StringBuilder("Exception while calling bridge#");
        error.append(method);
        if (this.clazz != null) {
            error.append("\n\tclass: ").append(this.clazz.getName());
        }
        if (this.path.size() > 0) {
            error.append("\n\tpath: ");
            for (XMember pathNode : this.path) {
                error.append(pathNode.getName()).append(".");
            }
            error.deleteCharAt(error.length() - 1);
        }
        if (this.fieldName != null) {
            error.append("\n\tfield bridge: ").append(this.fieldName);
        }
        throw new BridgeException(error.toString(), e);
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        try {
            this.delegate.set(name, value, document, luceneOptions);
        }
        catch (Exception e) {
            throw this.buildBridgeException(e, "set");
        }
    }

    public ContextualExceptionBridge pushMethod(XMember xMember) {
        this.path.add(xMember);
        return this;
    }

    public ContextualExceptionBridge popMethod() {
        this.path.remove(this.path.size() - 1);
        return this;
    }
}

