/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.LoaderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLoaderHelper {
    private static final int MAX_IN_CLAUSE = 500;
    private static final Logger log = LoggerFactory.make();

    public static Object load(EntityInfo entityInfo, Session session) {
        Object maybeProxy = session.load(entityInfo.clazz, entityInfo.id);
        try {
            Hibernate.initialize((Object)maybeProxy);
        }
        catch (RuntimeException e) {
            if (LoaderHelper.isObjectNotFoundException(e)) {
                log.debug("Object found in Search index but not in database: {} with id {}", (Object)entityInfo.clazz, (Object)entityInfo.id);
                maybeProxy = null;
            }
            throw e;
        }
        return maybeProxy;
    }

    public static void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor) {
        boolean exact;
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            return;
        }
        Set<Class<?>> indexedEntities = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
        DocumentBuilderIndexedEntity<?> builder = searchFactoryImplementor.getDocumentBuilderIndexedEntity(indexedEntities.iterator().next());
        String idName = builder.getIdentifierName();
        Disjunction disjunction = Restrictions.disjunction();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        for (int index = 0; index < loop; ++index) {
            int max = index * 500 + 500 <= maxResults ? index * 500 + 500 : maxResults;
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            for (int entityInfoIndex = index * 500; entityInfoIndex < max; ++entityInfoIndex) {
                ids.add(entityInfos[entityInfoIndex].id);
            }
            disjunction.add(Restrictions.in((String)idName, ids));
        }
        criteria.add((Criterion)disjunction);
        criteria.list();
    }

    public static List returnAlreadyLoadedObjectsInCorrectOrder(EntityInfo[] entityInfos, Session session) {
        ArrayList<Object> result = new ArrayList<Object>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            Object element = session.load(entityInfo.clazz, entityInfo.id);
            if (Hibernate.isInitialized((Object)element)) {
                result.add(element);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Object found in Search index but not in database: {} with {}", (Object)entityInfo.clazz, (Object)entityInfo.id);
        }
        return result;
    }
}

