/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

class DeleteWorkDelegate
implements LuceneWorkDelegate {
    private static final Logger log = LoggerFactory.make();
    private final Workspace workspace;

    DeleteWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    public void performWork(LuceneWork work, IndexWriter writer) {
        Class entityType = work.getEntityClass();
        Serializable id = work.getId();
        log.trace("Removing {}#{} by query.", (Object)entityType, (Object)id);
        DocumentBuilderIndexedEntity builder = this.workspace.getDocumentBuilder(entityType);
        BooleanQuery entityDeletionQuery = new BooleanQuery();
        TermQuery idQueryTerm = new TermQuery(builder.getTerm(id));
        entityDeletionQuery.add((Query)idQueryTerm, BooleanClause.Occur.MUST);
        Term classNameQueryTerm = new Term("_hibernate_class", entityType.getName());
        TermQuery classNameQuery = new TermQuery(classNameQueryTerm);
        entityDeletionQuery.add((Query)classNameQuery, BooleanClause.Occur.MUST);
        try {
            writer.deleteDocuments((Query)entityDeletionQuery);
        }
        catch (Exception e) {
            String message = "Unable to remove " + entityType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
    }
}

