/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.FileTimeStampChecker;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlMetaEmbeddable;
import org.hibernate.jpamodelgen.xml.XmlMetaEntity;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.EntityMappings;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.ObjectFactory;
import org.hibernate.jpamodelgen.xml.jaxb.Persistence;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitDefaults;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitMetadata;
import org.xml.sax.SAXException;

public class XmlParser {
    private static final String ORM_XML = "/META-INF/orm.xml";
    private static final String PERSISTENCE_XML_XSD = "persistence_2_0.xsd";
    private static final String ORM_XSD = "orm_2_0.xsd";
    private static final String SERIALIZATION_FILE_NAME = "Hibernate-Static-Metamodel-Generator.tmp";
    private static final String PATH_SEPARATOR = "/";
    private Context context;
    private List<EntityMappings> entityMappings;

    public XmlParser(Context context) {
        this.context = context;
        this.entityMappings = new ArrayList<EntityMappings>();
    }

    public void parseXml() {
        Collection<String> mappingFileNames = this.determineMappingFileNames();
        if (this.context.doLazyXmlParsing() && this.mappingFilesUnchanged(mappingFileNames)) {
            return;
        }
        this.loadEntityMappings(mappingFileNames);
        this.determineDefaultAccessTypeAndMetaCompleteness();
        this.determineXmlAccessTypes();
        if (!this.context.isPersistenceUnitCompletelyXmlConfigured()) {
            this.determineAnnotationAccessTypes();
        }
        for (EntityMappings mappings : this.entityMappings) {
            String defaultPackageName = mappings.getPackage();
            this.parseEntities(mappings.getEntity(), defaultPackageName);
            this.parseEmbeddable(mappings.getEmbeddable(), defaultPackageName);
            this.parseMappedSuperClass(mappings.getMappedSuperclass(), defaultPackageName);
        }
    }

    private Collection<String> determineMappingFileNames() {
        ArrayList<String> mappingFileNames = new ArrayList<String>();
        Persistence persistence = this.parseXml(this.context.getPersistenceXmlLocation(), Persistence.class, PERSISTENCE_XML_XSD);
        if (persistence != null) {
            List<Persistence.PersistenceUnit> persistenceUnits = persistence.getPersistenceUnit();
            for (Persistence.PersistenceUnit unit : persistenceUnits) {
                mappingFileNames.addAll(unit.getMappingFile());
            }
        }
        mappingFileNames.add(ORM_XML);
        mappingFileNames.addAll(this.context.getOrmXmlFiles());
        return mappingFileNames;
    }

    private void loadEntityMappings(Collection<String> mappingFileNames) {
        for (String mappingFile : mappingFileNames) {
            EntityMappings mapping = this.parseXml(mappingFile, EntityMappings.class, ORM_XSD);
            if (mapping == null) continue;
            this.entityMappings.add(mapping);
        }
    }

    private boolean mappingFilesUnchanged(Collection<String> mappingFileNames) {
        boolean mappingFilesUnchanged = false;
        FileTimeStampChecker fileStampCheck = new FileTimeStampChecker();
        for (String mappingFile : mappingFileNames) {
            try {
                URL url = this.getClass().getResource(mappingFile);
                if (url == null) continue;
                File file = new File(url.toURI());
                this.context.logMessage(Diagnostic.Kind.OTHER, "Check file  " + mappingFile);
                if (!file.exists()) continue;
                fileStampCheck.add(mappingFile, file.lastModified());
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        FileTimeStampChecker serializedTimeStampCheck = this.loadTimeStampCache();
        if (serializedTimeStampCheck.equals(fileStampCheck)) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "XML parsing will be skipped due to unchanged xml files");
            mappingFilesUnchanged = true;
        } else {
            this.saveTimeStampCache(fileStampCheck);
        }
        return mappingFilesUnchanged;
    }

    private void saveTimeStampCache(FileTimeStampChecker fileStampCheck) {
        try {
            File file = this.getSerializationTmpFile();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(fileStampCheck);
            out.close();
            this.context.logMessage(Diagnostic.Kind.OTHER, "Serialized " + fileStampCheck + " into " + file.getAbsolutePath());
        }
        catch (IOException e) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Error serializing  " + fileStampCheck);
        }
    }

    private File getSerializationTmpFile() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmpDir, SERIALIZATION_FILE_NAME);
    }

    private FileTimeStampChecker loadTimeStampCache() {
        FileTimeStampChecker serializedTimeStampCheck = new FileTimeStampChecker();
        File file = null;
        try {
            file = this.getSerializationTmpFile();
            if (file.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                serializedTimeStampCheck = (FileTimeStampChecker)in.readObject();
                in.close();
            }
        }
        catch (Exception e) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Error de-serializing  " + file);
        }
        return serializedTimeStampCheck;
    }

    private void parseEntities(Collection<Entity> entities, String defaultPackageName) {
        for (Entity entity : entities) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, entity.getClazz());
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(entity, defaultPackageName, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEntity(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurance.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private void parseEmbeddable(Collection<Embeddable> embeddables, String defaultPackageName) {
        for (Embeddable embeddable : embeddables) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, embeddable.getClazz());
            String pkg = StringUtil.packageNameFromFqcn(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEmbeddable metaEntity = new XmlMetaEmbeddable(embeddable, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEmbeddable(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurance.");
            }
            this.context.addMetaEmbeddable(fqcn, metaEntity);
        }
    }

    private void parseMappedSuperClass(Collection<MappedSuperclass> mappedSuperClasses, String defaultPackageName) {
        for (MappedSuperclass mappedSuperClass : mappedSuperClasses) {
            String fqcn = StringUtil.determineFullyQualifiedClassName(defaultPackageName, mappedSuperClass.getClazz());
            String pkg = StringUtil.packageNameFromFqcn(fqcn);
            if (!this.xmlMappedTypeExists(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(mappedSuperClass, pkg, this.getXmlMappedType(fqcn), this.context);
            if (this.context.containsMetaEmbeddable(fqcn)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fqcn + " was already processed once. Skipping second occurance.");
            }
            this.context.addMetaEntity(fqcn, metaEntity);
        }
    }

    private <T> T parseXml(String resource, Class<T> clazz, String schemaName) {
        InputStream stream = this.getInputStreamForResource(resource);
        if (stream == null) {
            this.context.logMessage(Diagnostic.Kind.OTHER, resource + " not found.");
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (schemaName != null) {
                unmarshaller.setSchema(this.getSchema(schemaName));
            }
            return clazz.cast(unmarshaller.unmarshal(stream));
        }
        catch (JAXBException e) {
            String message = "Error unmarshalling " + resource + " with exception :\n " + (Object)((Object)e);
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
        catch (Exception e) {
            String message = "Error reading " + resource + " with exception :\n " + e;
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
    }

    private Schema getSchema(String schemaName) {
        Schema schema = null;
        URL schemaUrl = this.getClass().getClassLoader().getResource(schemaName);
        if (schemaUrl == null) {
            return schema;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to create schema for " + schemaName + ": " + e.getMessage());
        }
        return schema;
    }

    private InputStream getInputStreamForResource(String resource) {
        InputStream ormStream;
        if (!resource.startsWith(PATH_SEPARATOR)) {
            resource = PATH_SEPARATOR + resource;
        }
        String pkg = this.getPackage(resource);
        String name = this.getRelativeName(resource);
        try {
            FileObject fileObject = this.context.getProcessingEnvironment().getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream(resource);
        }
        return ormStream;
    }

    private String getPackage(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(PATH_SEPARATOR));
    }

    private String getRelativeName(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    private boolean xmlMappedTypeExists(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName) != null;
    }

    private TypeElement getXmlMappedType(String fullyQualifiedClassName) {
        Elements utils = this.context.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName);
    }

    private org.hibernate.jpamodelgen.util.AccessType determineEntityAccessType(EntityMappings mappings) {
        org.hibernate.jpamodelgen.util.AccessType accessType = this.context.getPersistenceUnitDefaultAccessType();
        if (mappings.getAccess() != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(mappings.getAccess());
        }
        return accessType;
    }

    private void determineXmlAccessTypes() {
        for (EntityMappings mappings : this.entityMappings) {
            AccessTypeInformation accessInfo;
            AccessType type;
            org.hibernate.jpamodelgen.util.AccessType explicitAccessType;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            org.hibernate.jpamodelgen.util.AccessType defaultAccessType = this.determineEntityAccessType(mappings);
            for (Entity entity : mappings.getEntity()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = entity.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (MappedSuperclass mappedSuperClass : mappings.getMappedSuperclass()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = mappedSuperClass.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
            for (Embeddable embeddable : mappings.getEmbeddable()) {
                name = embeddable.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                explicitAccessType = null;
                type = embeddable.getAccess();
                if (type != null) {
                    explicitAccessType = this.mapXmlAccessTypeToJpaAccessType(type);
                }
                accessInfo = new AccessTypeInformation(fqcn, explicitAccessType, defaultAccessType);
                this.context.addAccessTypeInformation(fqcn, accessInfo);
            }
        }
    }

    private void determineAnnotationAccessTypes() {
        for (EntityMappings mappings : this.entityMappings) {
            TypeElement element;
            String fqcn;
            String name;
            String packageName = mappings.getPackage();
            for (Entity entity : mappings.getEntity()) {
                name = entity.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
            for (MappedSuperclass mappedSuperClass : mappings.getMappedSuperclass()) {
                name = mappedSuperClass.getClazz();
                fqcn = StringUtil.determineFullyQualifiedClassName(packageName, name);
                element = this.context.getTypeElementForFullyQualifiedName(fqcn);
                if (element == null) continue;
                TypeUtils.determineAccessTypeForHierarchy(element, this.context);
            }
        }
    }

    private void determineDefaultAccessTypeAndMetaCompleteness() {
        for (EntityMappings mappings : this.entityMappings) {
            AccessType xmlAccessType;
            PersistenceUnitDefaults persistenceUnitDefaults;
            PersistenceUnitMetadata meta = mappings.getPersistenceUnitMetadata();
            if (meta == null) continue;
            if (meta.getXmlMappingMetadataComplete() != null) {
                this.context.setPersistenceUnitCompletelyXmlConfigured(true);
            }
            if ((persistenceUnitDefaults = meta.getPersistenceUnitDefaults()) == null || (xmlAccessType = persistenceUnitDefaults.getAccess()) == null) break;
            this.context.setPersistenceUnitDefaultAccessType(this.mapXmlAccessTypeToJpaAccessType(xmlAccessType));
            break;
        }
    }

    private org.hibernate.jpamodelgen.util.AccessType mapXmlAccessTypeToJpaAccessType(AccessType xmlAccessType) {
        switch (xmlAccessType) {
            case FIELD: {
                return org.hibernate.jpamodelgen.util.AccessType.FIELD;
            }
            case PROPERTY: {
                return org.hibernate.jpamodelgen.util.AccessType.PROPERTY;
            }
        }
        return null;
    }
}

