/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import javax.persistence.AccessType;

public class AccessTypeInformation {
    private final String fqcn;
    private AccessType explicitAccessType;
    private AccessType defaultAccessType;
    private static final AccessType DEFAULT_ACCESS_TYPE = AccessType.PROPERTY;

    public AccessTypeInformation(String fqcn, AccessType explicitAccessType, AccessType defaultAccessType) {
        this.fqcn = fqcn;
        this.explicitAccessType = explicitAccessType;
        this.defaultAccessType = defaultAccessType;
    }

    public boolean isAccessTypeResolved() {
        return this.explicitAccessType != null || this.defaultAccessType != null;
    }

    public AccessType getAccessType() {
        if (this.explicitAccessType != null) {
            return this.explicitAccessType;
        }
        if (this.defaultAccessType != null) {
            return this.defaultAccessType;
        }
        return DEFAULT_ACCESS_TYPE;
    }

    public void setDefaultAccessType(AccessType defaultAccessType) {
        this.defaultAccessType = defaultAccessType;
    }

    public void setExplicitAccessType(AccessType explicitAccessType) {
        this.explicitAccessType = explicitAccessType;
    }

    public AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessTypeInformation");
        sb.append("{fqcn='").append(this.fqcn).append('\'');
        sb.append(", explicitAccessType=").append(this.explicitAccessType);
        sb.append(", defaultAccessType=").append(this.defaultAccessType);
        sb.append('}');
        return sb.toString();
    }
}

