/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.util;

import java.net.URL;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.jboss.logging.Logger;

public final class HibernateEhcacheUtils {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)HibernateEhcacheUtils.class.getName());

    private HibernateEhcacheUtils() {
    }

    public static Configuration loadAndCorrectConfiguration(URL url) {
        Configuration config = ConfigurationFactory.parseConfiguration((URL)url);
        if (config == null) {
            return null;
        }
        if (config.getDefaultCacheConfiguration().isTerracottaClustered()) {
            if (TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)config.getDefaultCacheConfiguration().getTerracottaConfiguration().getValueMode())) {
                LOG.incompatibleCacheValueMode();
                config.getDefaultCacheConfiguration().getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
            }
            HibernateEhcacheUtils.setupHibernateTimeoutBehavior(config.getDefaultCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration());
        }
        for (CacheConfiguration cacheConfig : config.getCacheConfigurations().values()) {
            if (!cacheConfig.isTerracottaClustered()) continue;
            if (TerracottaConfiguration.ValueMode.IDENTITY.equals((Object)cacheConfig.getTerracottaConfiguration().getValueMode())) {
                LOG.incompatibleCacheValueModePerCache(cacheConfig.getName());
                cacheConfig.getTerracottaConfiguration().setValueMode(TerracottaConfiguration.ValueMode.SERIALIZATION.name());
            }
            HibernateEhcacheUtils.setupHibernateTimeoutBehavior(cacheConfig.getTerracottaConfiguration().getNonstopConfiguration());
        }
        return config;
    }

    private static void setupHibernateTimeoutBehavior(NonstopConfiguration nonstopConfig) {
        nonstopConfig.getTimeoutBehavior().setType(TimeoutBehaviorConfiguration.TimeoutBehaviorType.EXCEPTION.getTypeName());
    }

    public static void validateEhcache(Ehcache cache) throws CacheException {
        CacheConfiguration cacheConfig = cache.getCacheConfiguration();
        if (cacheConfig.isTerracottaClustered()) {
            TerracottaConfiguration tcConfig = cacheConfig.getTerracottaConfiguration();
            switch (tcConfig.getValueMode()) {
                case IDENTITY: {
                    throw new CacheException("The clustered Hibernate cache " + cache.getName() + " is using IDENTITY value mode.\n" + "Identity value mode cannot be used with Hibernate cache regions.");
                }
            }
        }
    }
}

