/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.javassist;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.javassist.SerializableProxy;
import org.hibernate.type.CompositeType;

public class JavassistLazyInitializer
extends BasicLazyInitializer
implements MethodHandler {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JavassistLazyInitializer.class);
    private final Class[] interfaces;
    private boolean constructed;

    public JavassistLazyInitializer(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType, SharedSessionContractImplementor session, boolean overridesEquals) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session, overridesEquals);
        this.interfaces = interfaces;
    }

    protected void constructed() {
        this.constructed = true;
    }

    public Object invoke(Object proxy, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (this.constructed) {
            Object result;
            if (thisMethod.getName().startsWith("$$_hibernate_")) {
                return proceed.invoke(proxy, args);
            }
            try {
                result = this.invoke(thisMethod, args, proxy);
            }
            catch (Throwable t) {
                throw new Exception(t.getCause());
            }
            if (result == INVOKE_IMPLEMENTATION) {
                Object target = this.getImplementation();
                try {
                    Object returnValue;
                    if (ReflectHelper.isPublic(this.persistentClass, thisMethod)) {
                        if (!thisMethod.getDeclaringClass().isInstance(target)) {
                            throw new ClassCastException(target.getClass().getName() + " incompatible with " + thisMethod.getDeclaringClass().getName());
                        }
                        returnValue = thisMethod.invoke(target, args);
                    } else {
                        thisMethod.setAccessible(true);
                        returnValue = thisMethod.invoke(target, args);
                    }
                    if (returnValue == target) {
                        if (returnValue.getClass().isInstance(proxy)) {
                            return proxy;
                        }
                        LOG.narrowingProxy(returnValue.getClass());
                    }
                    return returnValue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return result;
        }
        if (thisMethod.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        return proceed.invoke(proxy, args);
    }

    @Override
    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.isReadOnlySettingAvailable() ? Boolean.valueOf(this.isReadOnly()) : this.isReadOnlyBeforeAttachedToSession(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

