/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.graalvm.buildtools.model.resources.ClassPathEntryAnalyzer;
import org.graalvm.buildtools.model.resources.Helper;
import org.graalvm.buildtools.model.resources.PatternValue;
import org.graalvm.buildtools.model.resources.ResourceFilter;
import org.graalvm.buildtools.model.resources.ResourcesConfigModel;
import org.graalvm.buildtools.model.resources.ResourcesConfigModelSerializer;
import org.graalvm.buildtools.model.resources.ResourcesModel;
import org.graalvm.buildtools.utils.SharedConstants;

public abstract class AbstractResourceConfigMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/native/generated", property="resources.outputDir", required=true)
    private File outputDirectory;
    @Parameter(property="resources.bundles")
    private List<String> resourceBundles;
    @Parameter(property="resources.includedPatterns")
    private List<String> resourceIncludedPatterns;
    @Parameter(property="resources.excludedPatterns")
    private List<String> resourceExcludedPatterns;
    @Parameter(property="resources.autodetection.enabled", defaultValue="false")
    private boolean isDetectionEnabled;
    @Parameter(property="resources.autodetection.restrictToModuleDependencies", defaultValue="true")
    private boolean isDetectionRestrictedToModuleDependencies;
    @Parameter(property="resources.autodetection.detectionExclusionPatterns")
    private List<String> detectionExclusionPatterns;
    @Parameter(property="resources.autodetection.ignoreExistingResourcesConfig", defaultValue="false")
    private boolean ignoreExistingResourcesConfig;

    abstract String getConfigurationKind();

    public void execute() throws MojoExecutionException {
        Set includes = Helper.asPatternValues(this.resourceIncludedPatterns);
        Set excludes = Helper.asPatternValues(this.resourceExcludedPatterns);
        Set bundles = Helper.asNamedValues(this.resourceBundles);
        if (this.isDetectionEnabled) {
            try {
                this.detectResourcesFromClasspath(includes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to infer resources", (Exception)e);
            }
        }
        try {
            ResourcesConfigModel model = new ResourcesConfigModel(new ResourcesModel(includes, excludes), bundles);
            this.serializeModel(model, new File(this.outputDirectory, this.getConfigurationKind() + "/resource-config.json"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write resource-config.json file", (Exception)e);
        }
    }

    private Set<File> findAllProjectArtifacts() {
        LinkedHashSet<File> all = new LinkedHashSet<File>();
        all.add(this.mavenProject.getArtifact().getFile());
        all.addAll(this.transitiveProjectsArtifacts());
        Collection<? extends File> extraProjectArtifacts = this.getExtraProjectArtifacts();
        all.addAll(extraProjectArtifacts);
        return all;
    }

    protected Collection<? extends File> getExtraProjectArtifacts() {
        return Collections.emptySet();
    }

    private Set<File> findAllExternalArtifacts() {
        LinkedHashSet<File> all = new LinkedHashSet<File>(this.allTransitiveArtifacts());
        all.removeAll(this.transitiveProjectsArtifacts());
        return all;
    }

    private Set<File> allTransitiveArtifacts() {
        return this.mavenProject.getArtifacts().stream().map(Artifact::getFile).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<File> transitiveProjectsArtifacts() {
        return this.session.getProjectDependencyGraph().getUpstreamProjects(this.mavenProject, true).stream().map(p -> p.getArtifact().getFile()).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <T> Set<T> safeAsSet(Collection<T> elements) {
        if (elements == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<T>(elements);
    }

    private void detectResourcesFromClasspath(Set<PatternValue> output) throws IOException {
        ResourceFilter filter = new ResourceFilter(AbstractResourceConfigMojo.safeAsSet(this.detectionExclusionPatterns == null ? SharedConstants.DEFAULT_EXCLUDES_FOR_RESOURCE_DETECTION : this.detectionExclusionPatterns));
        LinkedHashSet<String> detectedResources = new LinkedHashSet<String>();
        Set<File> artifacts = this.findAllProjectArtifacts();
        if (!this.isDetectionRestrictedToModuleDependencies) {
            artifacts.addAll(this.findAllExternalArtifacts());
        }
        for (File file : artifacts) {
            this.detectResourcesFromClasspathEntry(filter, detectedResources, file);
        }
        if (!detectedResources.isEmpty()) {
            output.addAll(detectedResources.stream().map(Pattern::quote).map(PatternValue::new).collect(Collectors.toList()));
        }
    }

    private void detectResourcesFromClasspathEntry(ResourceFilter filter, Set<String> detectedResources, File file) throws IOException {
        ClassPathEntryAnalyzer analyzer = ClassPathEntryAnalyzer.of((File)file, arg_0 -> ((ResourceFilter)filter).shouldIncludeResource(arg_0), (boolean)this.ignoreExistingResourcesConfig);
        List resources = analyzer.getResources();
        this.getLog().info((CharSequence)String.format("Detected resources for %s are %s", file, resources));
        detectedResources.addAll(resources);
    }

    private void serializeModel(ResourcesConfigModel model, File outputFile) throws IOException {
        ResourcesConfigModelSerializer.serialize((ResourcesConfigModel)model, (File)outputFile);
        this.getLog().info((CharSequence)("Resources configuration written into " + outputFile));
    }
}

