/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.streams.Output;

public abstract class BufferedOutput
implements Output {
    protected static final Integer ZERO = 0;
    protected static final GrizzlyFuture<Integer> ZERO_READY_FUTURE = ReadyFutureImpl.create(0);
    protected final int bufferSize;
    protected CompositeBuffer multiBufferWindow;
    private Buffer buffer;
    private int lastSlicedPosition;
    protected final AtomicBoolean isClosed = new AtomicBoolean();

    public BufferedOutput() {
        this(8192);
    }

    public BufferedOutput(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    protected abstract void onClosed() throws IOException;

    protected abstract GrizzlyFuture<Integer> flush0(Buffer var1, CompletionHandler<Integer> var2) throws IOException;

    protected abstract Buffer newBuffer(int var1);

    protected abstract Buffer reallocateBuffer(Buffer var1, int var2);

    @Override
    public void write(byte data) throws IOException {
        this.ensureBufferCapacity(1);
        this.buffer.put(data);
    }

    @Override
    public void write(Buffer bufferToWrite) throws IOException {
        boolean isInternalBufferEmpty;
        if (this.multiBufferWindow == null) {
            this.multiBufferWindow = CompositeBuffer.newBuffer();
        }
        boolean bl = isInternalBufferEmpty = this.buffer == null || this.buffer.position() - this.lastSlicedPosition == 0;
        if (!isInternalBufferEmpty) {
            Buffer slice = this.buffer.slice(this.lastSlicedPosition, this.buffer.position());
            this.multiBufferWindow.append(slice);
            this.lastSlicedPosition = this.buffer.position();
        }
        this.multiBufferWindow.append(bufferToWrite);
        this.ensureBufferCapacity(0);
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void ensureBufferCapacity(int size) throws IOException {
        if (size > this.bufferSize) {
            throw new IllegalArgumentException("Size exceeds max size limit: " + this.bufferSize);
        }
        if (this.getBufferedSize() >= this.bufferSize) {
            this.overflow(null);
        }
        if (size == 0) {
            return;
        }
        if (this.buffer != null) {
            int bufferRemaining = this.buffer.remaining();
            if (bufferRemaining < size) {
                this.overflow(null);
                this.ensureBufferCapacity(size);
            }
        } else {
            this.buffer = this.newBuffer(this.bufferSize);
        }
    }

    private GrizzlyFuture<Integer> overflow(CompletionHandler<Integer> completionHandler) throws IOException {
        if (this.multiBufferWindow != null) {
            GrizzlyFuture<Integer> future;
            if (this.buffer != null && this.buffer.position() > this.lastSlicedPosition) {
                Buffer slice = this.buffer.slice(this.lastSlicedPosition, this.buffer.position());
                this.lastSlicedPosition = this.buffer.position();
                this.multiBufferWindow.append(slice);
            }
            if ((future = this.flush0(this.multiBufferWindow, completionHandler)).isDone()) {
                this.multiBufferWindow.removeAll();
                this.multiBufferWindow.clear();
                if (this.buffer != null) {
                    if (!this.buffer.isComposite()) {
                        this.buffer.clear();
                    } else {
                        this.buffer = null;
                    }
                    this.lastSlicedPosition = 0;
                }
            } else {
                this.multiBufferWindow = null;
                this.buffer = null;
                this.lastSlicedPosition = 0;
            }
            return future;
        }
        if (this.buffer != null && this.buffer.position() > 0) {
            this.buffer.flip();
            GrizzlyFuture<Integer> future = this.flush0(this.buffer, completionHandler);
            if (future.isDone() && !this.buffer.isComposite()) {
                this.buffer.clear();
            } else {
                this.buffer = null;
            }
            return future;
        }
        return this.flush0(null, completionHandler);
    }

    @Override
    public GrizzlyFuture<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return this.overflow(completionHandler);
    }

    @Override
    public GrizzlyFuture<Integer> close(final CompletionHandler<Integer> completionHandler) throws IOException {
        if (!this.isClosed.getAndSet(true) && this.buffer != null && this.buffer.position() > 0) {
            final SafeFutureImpl<Integer> future = SafeFutureImpl.create();
            try {
                this.overflow(new CompletionHandler<Integer>(){

                    @Override
                    public void cancelled() {
                        this.close(ZERO);
                    }

                    @Override
                    public void failed(Throwable throwable) {
                        this.close(ZERO);
                    }

                    @Override
                    public void completed(Integer result) {
                        this.close(result);
                    }

                    @Override
                    public void updated(Integer result) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close(Integer result) {
                        try {
                            BufferedOutput.this.onClosed();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (completionHandler != null) {
                                completionHandler.completed(result);
                            }
                            future.result(result);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return future;
        }
        if (completionHandler != null) {
            completionHandler.completed(ZERO);
        }
        return ZERO_READY_FUTURE;
    }

    protected int getBufferedSize() {
        int size = 0;
        if (this.multiBufferWindow != null) {
            size = this.multiBufferWindow.remaining();
        }
        if (this.buffer != null) {
            size += this.buffer.position() - this.lastSlicedPosition;
        }
        return size;
    }
}

