/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.ThreadCache;

public final class ReadyFutureImpl<R>
implements GrizzlyFuture<R> {
    private static final ThreadCache.CachedTypeIndex<ReadyFutureImpl> CACHE_IDX = ThreadCache.obtainIndex(ReadyFutureImpl.class, 4);
    protected R result;
    private Throwable failure;
    private boolean isCancelled;

    public static <R> ReadyFutureImpl<R> create() {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.isCancelled = true;
            return future;
        }
        return new ReadyFutureImpl<R>();
    }

    public static <R> ReadyFutureImpl<R> create(R result) {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.result = result;
            return future;
        }
        return new ReadyFutureImpl<R>(result);
    }

    public static <R> ReadyFutureImpl<R> create(Throwable failure) {
        ReadyFutureImpl<R> future = ReadyFutureImpl.takeFromCache();
        if (future != null) {
            future.failure = failure;
            return future;
        }
        return new ReadyFutureImpl<R>(failure);
    }

    private static <R> ReadyFutureImpl<R> takeFromCache() {
        return ThreadCache.takeFromCache(CACHE_IDX);
    }

    private ReadyFutureImpl() {
        this(null, null, true);
    }

    private ReadyFutureImpl(R result) {
        this(result, null, false);
    }

    private ReadyFutureImpl(Throwable failure) {
        this(null, failure, false);
    }

    private ReadyFutureImpl(R result, Throwable failure, boolean isCancelled) {
        this.result = result;
        this.failure = failure;
        this.isCancelled = isCancelled;
    }

    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        if (this.result != null) {
            return this.result;
        }
        throw new TimeoutException();
    }

    public void failure(Throwable failure) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    private void reset() {
        this.result = null;
        this.failure = null;
        this.isCancelled = false;
    }

    @Override
    public void markForRecycle(boolean recycleResult) {
        this.recycle(recycleResult);
    }

    @Override
    public void recycle(boolean recycleResult) {
        if (recycleResult && this.result != null && this.result instanceof Cacheable) {
            ((Cacheable)this.result).recycle();
        }
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public void recycle() {
        this.recycle(false);
    }
}

