/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.deps.Dependency;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;

public class LZMAPayloadCoding
implements PayloadCodingProvider {
    protected LZMAPayloadCoding() {
    }

    @Override
    public String getCoding() {
        return "lzma";
    }

    @Override
    public void fillRequirements(Consumer<Dependency> requirementsConsumer) {
        requirementsConsumer.accept(new Dependency("PayloadIsLzma", "4.4.6-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        return new LZMACompressorInputStream(in);
    }

    @Override
    public OutputStream createOutputStream(OutputStream out, Optional<String> optionalFlags) throws IOException {
        return new LZMACompressorOutputStream(out);
    }
}

