/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.quickstart.QuickStartDescriptorProcessor;
import org.eclipse.jetty.quickstart.QuickStartGeneratorConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickStartConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuickStartConfiguration.class);
    public static final Set<Class<? extends Configuration>> __replacedConfigurations = new HashSet<Class<? extends Configuration>>();
    public static final String ORIGIN_ATTRIBUTE = "org.eclipse.jetty.quickstart.origin";
    public static final String QUICKSTART_WEB_XML = "org.eclipse.jetty.quickstart.xml";
    public static final String MODE = "org.eclipse.jetty.quickstart.mode";
    private static final Mode DEFAULT_MODE = Mode.AUTO;

    public static void configureMode(Server server, String mode) {
        if (mode != null && Mode.valueOf(mode) == Mode.GENERATE) {
            server.setDryRun(true);
        }
    }

    public QuickStartConfiguration() {
        super(true);
        this.addDependencies(new Class[]{WebInfConfiguration.class});
        this.addDependents(new Class[]{WebXmlConfiguration.class});
    }

    private Mode getModeForContext(WebAppContext context) {
        Mode mode = (Mode)((Object)context.getAttribute(MODE));
        if (mode == null) {
            return DEFAULT_MODE;
        }
        return mode;
    }

    public void preConfigure(WebAppContext context) throws Exception {
        String war = context.getWar();
        if (StringUtil.isBlank((String)war) || !context.getBaseResource().isDirectory()) {
            throw new IllegalStateException("Invalid Quickstart location");
        }
        Resource quickStartWebXml = this.getQuickStartWebXml(context);
        Mode mode = this.getModeForContext(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("mode={} quickStartWebXml={} exists={} for {}", new Object[]{mode, quickStartWebXml, quickStartWebXml.exists(), context});
        }
        switch (mode.ordinal()) {
            case 0: {
                if (quickStartWebXml.exists()) {
                    LOG.info("Regenerating {} for {}", (Object)quickStartWebXml, (Object)context);
                } else {
                    LOG.info("Generating {} for {}", (Object)quickStartWebXml, (Object)context);
                }
                super.preConfigure(context);
                QuickStartGeneratorConfiguration generator = new QuickStartGeneratorConfiguration(true);
                this.configure(generator, context);
                context.addConfiguration(new Configuration[]{generator});
                break;
            }
            case 1: {
                if (quickStartWebXml.exists()) {
                    this.quickStart(context);
                    break;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No quickstart-web.xml found, starting webapp {} normally", (Object)context);
                }
                super.preConfigure(context);
                break;
            }
            case 2: {
                if (quickStartWebXml.exists()) {
                    this.quickStart(context);
                    break;
                }
                throw new IllegalStateException("No WEB-INF/quickstart-web.xml file for " + String.valueOf(context));
            }
            default: {
                throw new IllegalStateException("Unhandled QuickStart.Mode: " + String.valueOf((Object)mode));
            }
        }
    }

    protected void configure(QuickStartGeneratorConfiguration generator, WebAppContext context) throws IOException {
        Object attr = context.getAttribute(ORIGIN_ATTRIBUTE);
        if (attr != null) {
            generator.setOriginAttribute(attr.toString());
        }
        generator.setQuickStartWebXml((Resource)context.getAttribute(QUICKSTART_WEB_XML));
    }

    public void configure(WebAppContext context) throws Exception {
        Resource quickStartWebXml = this.getQuickStartWebXml(context);
        if (quickStartWebXml == null || !quickStartWebXml.exists()) {
            super.configure(context);
        } else {
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
            context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new QuickStartDescriptorProcessor());
            context.getObjectFactory().addDecorator((Decorator)new AnnotationDecorator(context));
            ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute("org.eclipse.jetty.containerInitializerStarter");
            if (starter != null) {
                throw new IllegalStateException("ServletContainerInitializersStarter already exists");
            }
            starter = new ServletContainerInitializersStarter(context);
            context.setAttribute("org.eclipse.jetty.containerInitializerStarter", (Object)starter);
            context.addBean((Object)starter, true);
            LOG.debug("configured {}", (Object)this);
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
        super.postConfigure(context);
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute("org.eclipse.jetty.containerInitializerStarter");
        if (starter != null) {
            context.removeBean((Object)starter);
            context.removeAttribute("org.eclipse.jetty.containerInitializerStarter");
        }
    }

    protected void quickStart(WebAppContext context) throws Exception {
        LOG.info("Quickstarting {}", (Object)context);
        context.setConfigurations(context.getConfigurations().stream().filter(c -> !__replacedConfigurations.contains(c.replaces()) && !__replacedConfigurations.contains(c.getClass())).collect(Collectors.toList()).toArray(new Configuration[0]));
        context.getMetaData().setWebDescriptor(new WebDescriptor((Resource)context.getAttribute(QUICKSTART_WEB_XML)));
        context.getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebDescriptor().getMajorVersion());
        context.getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebDescriptor().getMinorVersion());
    }

    public Resource getQuickStartWebXml(WebAppContext context) throws Exception {
        Resource qstart;
        Object attr = context.getAttribute(QUICKSTART_WEB_XML);
        if (attr instanceof Resource) {
            return (Resource)attr;
        }
        Resource webInf = context.getWebInf();
        if (webInf == null || !webInf.exists()) {
            switch (this.getModeForContext(context).ordinal()) {
                case 0: {
                    File tmp = new File(context.getBaseResource().getFile(), "WEB-INF");
                    if (!tmp.mkdirs()) {
                        throw new IllegalStateException("Unable to create directory " + String.valueOf(tmp));
                    }
                    webInf = context.getWebInf();
                    break;
                }
                case 1: 
                case 2: {
                    Resource qstart2 = context.getBaseResource().addPath("WEB-INF/quickstart-web.xml");
                    context.setAttribute(QUICKSTART_WEB_XML, (Object)qstart2);
                    return qstart2;
                }
            }
        }
        if (attr == null || StringUtil.isBlank((String)attr.toString())) {
            qstart = webInf.addPath("quickstart-web.xml");
        } else {
            try {
                qstart = Resource.newResource((Path)webInf.getFile().toPath().resolve(attr.toString()));
            }
            catch (Throwable th) {
                qstart = Resource.newResource((String)attr.toString());
            }
            context.setAttribute(QUICKSTART_WEB_XML, (Object)qstart);
        }
        context.setAttribute(QUICKSTART_WEB_XML, (Object)qstart);
        return qstart;
    }

    static {
        __replacedConfigurations.add(WebXmlConfiguration.class);
        __replacedConfigurations.add(MetaInfConfiguration.class);
        __replacedConfigurations.add(FragmentConfiguration.class);
        __replacedConfigurations.add(AnnotationConfiguration.class);
    }

    public static enum Mode {
        GENERATE,
        AUTO,
        QUICKSTART;

    }
}

