/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.DrillOnDimensionHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrilledAggregateResultSet
implements IAggregationResultSet {
    private IDiskArray bufferedStructureArray = new BufferedStructureArray(AggregationResultRow.getCreator(), 2000);
    private DimLevel[] dimLevel;
    private IAggregationResultRow resultObject;
    private IAggregationResultSet aggregationRsFromCube;
    private int currentPosition;
    private Map<IEdgeDrillFilter, List<DimLevel>> drillFilterTargetLevels;

    public DrilledAggregateResultSet(IAggregationResultSet aggregationRsFromCube, IAggregationResultSet[] aggregationRsFromDrill, List<DrillOnDimensionHierarchy> drillFilters) throws IOException, DataException {
        this.dimLevel = aggregationRsFromCube.getAllLevels();
        this.aggregationRsFromCube = aggregationRsFromCube;
        this.drillFilterTargetLevels = new HashMap<IEdgeDrillFilter, List<DimLevel>>();
        int i = 0;
        while (i < drillFilters.size()) {
            IEdgeDrillFilter[] filters = drillFilters.get(i).getDrillByDimension();
            int t = 0;
            while (t < filters.length) {
                this.drillFilterTargetLevels.put(filters[t], CubeQueryDefinitionUtil.getDrilledTargetLevels(filters[t]));
                ++t;
            }
            ++i;
        }
        if (aggregationRsFromDrill != null) {
            i = 0;
            while (i < aggregationRsFromDrill.length) {
                aggregationRsFromDrill[i].seek(0);
                ++i;
            }
        }
        int k = 0;
        while (k < aggregationRsFromCube.length()) {
            aggregationRsFromCube.seek(k);
            IEdgeDrillFilter targetDrill = this.getTargetDrillOperation(aggregationRsFromCube.getCurrentRow(), drillFilters);
            if (targetDrill == null) {
                this.bufferedStructureArray.add(aggregationRsFromCube.getCurrentRow());
            } else {
                List<IAggregationResultRow> tempBufferArray = this.populateResultSet(aggregationRsFromCube, targetDrill);
                List<IEdgeDrillFilter[]> drills = this.getRemainingDrillOperation(targetDrill, drillFilters);
                if (!drills.isEmpty()) {
                    tempBufferArray = this.populateNextResultSet(tempBufferArray, drills);
                }
                if (aggregationRsFromCube.getAggregationCount() == 0) {
                    this.removeDuplictedRow(tempBufferArray);
                } else {
                    this.recalculateAggregation(tempBufferArray, aggregationRsFromDrill);
                }
                if (!DrilledAggregateResultSet.isResultForRunningAggregation(aggregationRsFromCube)) {
                    this.sortAggregationRow(tempBufferArray);
                }
                Iterator<IAggregationResultRow> iter = tempBufferArray.iterator();
                while (iter.hasNext()) {
                    this.bufferedStructureArray.add(iter.next());
                }
                k = aggregationRsFromCube.getPosition();
            }
            ++k;
        }
        this.resultObject = (IAggregationResultRow)this.bufferedStructureArray.get(0);
    }

    private void sortAggregationRow(List<IAggregationResultRow> aggregationRows) {
        int[] sortType = this.aggregationRsFromCube.getSortType();
        final boolean[] sorts = new boolean[sortType.length];
        int i = 0;
        while (i < sortType.length) {
            sorts[i] = sortType[i] == 0 ? true : 1 != sortType[i];
            ++i;
        }
        Collections.sort(aggregationRows, new Comparator(){

            public int compare(Object o1, Object o2) {
                IAggregationResultRow row1 = (IAggregationResultRow)o1;
                IAggregationResultRow row2 = (IAggregationResultRow)o2;
                Object[] keyValues1 = new Object[row1.getLevelMembers().length];
                Object[] keyValues2 = new Object[row2.getLevelMembers().length];
                int i = 0;
                while (i < row1.getLevelMembers().length) {
                    keyValues1[i] = row1.getLevelMembers()[i] != null ? row1.getLevelMembers()[i].getKeyValues()[0] : null;
                    keyValues2[i] = row2.getLevelMembers()[i] != null ? row2.getLevelMembers()[i].getKeyValues()[0] : null;
                    ++i;
                }
                return CompareUtil.compare(keyValues1, keyValues2, sorts);
            }
        });
    }

    private void removeDuplictedRow(List<IAggregationResultRow> aggregationRows) {
        int i = 0;
        while (i < aggregationRows.size()) {
            IAggregationResultRow rows = aggregationRows.get(i);
            int k = i + 1;
            while (k < aggregationRows.size()) {
                if (rows.compareTo(aggregationRows.get(k)) == 0) {
                    aggregationRows.remove(k);
                    continue;
                }
                ++k;
            }
            ++i;
        }
    }

    private void recalculateAggregation(List<IAggregationResultRow> aggregationRows, IAggregationResultSet[] aggregationRsFromDrill) throws DataException, IOException {
        LinkedHashSet<Integer> duplicatedIndex = new LinkedHashSet<Integer>();
        int i = 0;
        while (i < aggregationRows.size()) {
            List<Integer> positions = this.getRowsPositionInAggregationRows(i, aggregationRows);
            Object[] aggregationValues = null;
            int k = 0;
            while (k < positions.size()) {
                if (k == 0) {
                    aggregationValues = this.findAggregationValue(aggregationRows.get(positions.get(k)), aggregationRsFromDrill);
                } else {
                    duplicatedIndex.add(positions.get(k));
                }
                ++k;
            }
            aggregationRows.get(i).setAggregationValues(aggregationValues);
            int baseIndex = 0;
            Iterator iter = duplicatedIndex.iterator();
            while (iter.hasNext()) {
                int index = (Integer)iter.next();
                aggregationRows.remove(index - baseIndex);
                ++baseIndex;
            }
            duplicatedIndex.clear();
            ++i;
        }
    }

    private Object[] findAggregationValue(IAggregationResultRow iAggregationResultRow, IAggregationResultSet[] aggregationRsFromDrill) throws IOException, DataException {
        HashMap<DimLevel, Object> targetValueMap = new HashMap<DimLevel, Object>();
        ArrayList<DimLevel> levels = new ArrayList<DimLevel>();
        int i = 0;
        while (i < this.dimLevel.length) {
            if (iAggregationResultRow.getLevelMembers()[i] != null && iAggregationResultRow.getLevelMembers()[i].getKeyValues() != null) {
                targetValueMap.put(this.dimLevel[i], iAggregationResultRow.getLevelMembers()[i].getKeyValues()[0]);
                levels.add(this.dimLevel[i]);
            }
            ++i;
        }
        IAggregationResultSet targetRs = null;
        int i2 = 0;
        while (i2 < aggregationRsFromDrill.length) {
            if (aggregationRsFromDrill[i2].getAllLevels().length == targetValueMap.keySet().size()) {
                DimLevel[] dimLevels = aggregationRsFromDrill[i2].getAllLevels();
                int j = 0;
                while (j < dimLevels.length) {
                    if (!targetValueMap.keySet().contains(dimLevels[j])) break;
                    if (j == dimLevels.length - 1) {
                        targetRs = aggregationRsFromDrill[i2];
                        break;
                    }
                    ++j;
                }
                if (targetRs != null) break;
            }
            ++i2;
        }
        if (targetRs == null) {
            return iAggregationResultRow.getAggregationValues();
        }
        boolean find = false;
        find = DrilledAggregateResultSet.isResultForRunningAggregation(targetRs) ? this.findValueOneByOne(targetRs, targetValueMap, levels) : this.findValueMatcher(targetRs, targetValueMap, levels);
        if (find) {
            Object[] value = new Object[this.aggregationRsFromCube.getAggregationCount()];
            int i3 = 0;
            while (i3 < value.length) {
                String name = this.aggregationRsFromCube.getAggregationDefinition().getAggregationFunctions()[i3].getName();
                int index = targetRs.getAggregationIndex(name);
                value[i3] = targetRs.getAggregationValue(index);
                ++i3;
            }
            return value;
        }
        return null;
    }

    private static boolean isResultForRunningAggregation(IAggregationResultSet ars) throws DataException {
        AggregationFunctionDefinition[] afds;
        AggregationDefinition ad = ars.getAggregationDefinition();
        if (ad != null && (afds = ad.getAggregationFunctions()) != null && afds.length == 1) {
            String functionName = afds[0].getFunctionName();
            IAggrFunction af = AggregationManager.getInstance().getAggregation(functionName);
            return af != null && af.getType() == 1;
        }
        return false;
    }

    private boolean findValueMatcher(IAggregationResultSet targetRs, Map<DimLevel, Object> targetLevelValue, List levels) {
        if (targetLevelValue.isEmpty()) {
            return true;
        }
        int start = 0;
        int state = 0;
        boolean find = false;
        int position = targetRs.getPosition();
        while (start < levels.size()) {
            int direction;
            int sortType;
            DimLevel level = (DimLevel)levels.get(start);
            Object value1 = targetLevelValue.get(level);
            Object value2 = null;
            int index = targetRs.getLevelIndex(level);
            Object[] keyValues = targetRs.getLevelKeyValue(index);
            if (keyValues != null) {
                value2 = keyValues[targetRs.getLevelKeyColCount(index) - 1];
            }
            int n = sortType = targetRs.getSortType(index) == 1 ? -1 : 1;
            int n2 = sortType * DrilledAggregateResultSet.compare(value1, value2) < 0 ? -1 : (direction = DrilledAggregateResultSet.compare(value1, value2) == 0 ? 0 : 1);
            if (direction < 0 && position > 0 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    targetRs.seek(--position);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction > 0 && position < targetRs.length() - 1 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    targetRs.seek(++position);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction == 0) {
                if (start == levels.size() - 1) {
                    find = true;
                    break;
                }
                ++start;
                continue;
            }
            if (position < 0 || position >= targetRs.length()) {
                return false;
            }
            return false;
        }
        return find;
    }

    /*
     * Unable to fully structure code
     */
    private boolean findValueOneByOne(IAggregationResultSet targetRs, Map<DimLevel, Object> targetLevelValue, List levels) throws IOException {
        position = 0;
        if (targetRs.length() > 0 && !levels.isEmpty()) ** GOTO lbl23
        return true;
lbl-1000:
        // 1 sources

        {
            targetRs.seek(position);
            match = true;
            i = 0;
            while (i < levels.size()) {
                level = (DimLevel)levels.get(i);
                value1 = targetLevelValue.get(level);
                value2 = null;
                index = targetRs.getLevelIndex(level);
                keyValues = targetRs.getLevelKeyValue(index);
                if (keyValues != null) {
                    value2 = keyValues[targetRs.getLevelKeyColCount(index) - 1];
                }
                if (!(value1 == value2 || value1 != null && value2 != null && value1.equals(value2))) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                return true;
            }
            ++position;
lbl23:
            // 2 sources

            ** while (position < targetRs.length())
        }
lbl24:
        // 1 sources

        return false;
    }

    static int compare(Object value1, Object value2) {
        if (value1 == value2) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof Comparable) {
            return ((Comparable)value1).compareTo(value2);
        }
        return value1.toString().compareTo(value2.toString());
    }

    private List<Integer> getRowsPositionInAggregationRows(int index, List<IAggregationResultRow> aggregationRows) {
        ArrayList<Integer> position = new ArrayList<Integer>();
        position.add(index);
        IAggregationResultRow row = aggregationRows.get(index);
        int i = index + 1;
        while (i < aggregationRows.size()) {
            if (row.compareTo(aggregationRows.get(i)) == 0) {
                position.add(i);
            }
            ++i;
        }
        return position;
    }

    private List<IAggregationResultRow> populateNextResultSet(List<IAggregationResultRow> tempBufferArray, List<IEdgeDrillFilter[]> nextDrills) throws IOException {
        ArrayList<IAggregationResultRow> finalBufferArray = new ArrayList<IAggregationResultRow>();
        int i = 0;
        while (i < tempBufferArray.size()) {
            IAggregationResultRow rows = tempBufferArray.get(i);
            int k = 0;
            while (k < nextDrills.size()) {
                IEdgeDrillFilter[] filters = nextDrills.get(k);
                int t = 0;
                while (t < filters.length) {
                    IEdgeDrillFilter targetFilter = filters[t];
                    rows = this.populateResultSet(rows, targetFilter);
                    ++t;
                }
                ++k;
            }
            finalBufferArray.add(rows);
            ++i;
        }
        return finalBufferArray;
    }

    private IAggregationResultRow populateResultSet(IAggregationResultRow aggregationRow, IEdgeDrillFilter targetDrill) throws IOException {
        IAggregationResultRow row = aggregationRow;
        if (this.isDrilledElement(aggregationRow, targetDrill)) {
            Member[] drillMember = new Member[this.dimLevel.length];
            int i = 0;
            while (i < drillMember.length) {
                List<DimLevel> comparableLevels;
                drillMember[i] = new Member();
                drillMember[i] = !this.dimLevel[i].getDimensionName().equals(targetDrill.getTargetHierarchy().getDimension().getName()) ? aggregationRow.getLevelMembers()[i] : ((comparableLevels = this.drillFilterTargetLevels.get(targetDrill)) != null && comparableLevels.contains(this.dimLevel[i]) ? aggregationRow.getLevelMembers()[i] : null);
                ++i;
            }
            row = new AggregationResultRow(drillMember, aggregationRow.getAggregationValues());
        }
        return row;
    }

    private List<IAggregationResultRow> populateResultSet(IAggregationResultSet aggregationRsFromCube, IEdgeDrillFilter targetDrill) throws IOException {
        ArrayList<IAggregationResultRow> drillResultSet = new ArrayList<IAggregationResultRow>();
        int k = aggregationRsFromCube.getPosition();
        while (k < aggregationRsFromCube.length()) {
            aggregationRsFromCube.seek(k);
            if (!this.isDrilledElement(aggregationRsFromCube.getCurrentRow(), targetDrill)) {
                aggregationRsFromCube.seek(k - 1);
                break;
            }
            IAggregationResultRow row = this.populateResultSet(aggregationRsFromCube.getCurrentRow(), targetDrill);
            drillResultSet.add(row);
            ++k;
        }
        return drillResultSet;
    }

    private IEdgeDrillFilter getTargetDrillOperation(IAggregationResultRow row, List<DrillOnDimensionHierarchy> drillFilters) {
        int i = 0;
        while (i < drillFilters.size()) {
            DrillOnDimensionHierarchy filters = drillFilters.get(i);
            Iterator<List<IEdgeDrillFilter>> iter = filters.getDrillFilterIterator();
            while (iter.hasNext()) {
                List<IEdgeDrillFilter> drills = iter.next();
                int j = 0;
                while (j < drills.size()) {
                    if (this.isDrilledElement(row, drills.get(j))) {
                        return drills.get(j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private List<IEdgeDrillFilter[]> getRemainingDrillOperation(IEdgeDrillFilter targetDrill, List<DrillOnDimensionHierarchy> drillFilters) {
        ArrayList<IEdgeDrillFilter[]> list = new ArrayList<IEdgeDrillFilter[]>();
        int i = 0;
        while (i < drillFilters.size()) {
            DrillOnDimensionHierarchy filters = drillFilters.get(i);
            if (!filters.contains(targetDrill)) {
                list.add(filters.getDrillByDimension());
            }
            ++i;
        }
        return list;
    }

    private boolean isDrilledElement(IAggregationResultRow row, IEdgeDrillFilter drill) {
        List<DimLevel> comparableLevels = this.drillFilterTargetLevels.get(drill);
        boolean matched = true;
        Object[] tuple = drill.getTuple().toArray();
        int j = 0;
        while (j < tuple.length) {
            if (tuple[j] != null) {
                int levelIndex = -1;
                int t = 0;
                while (t < this.dimLevel.length) {
                    if (this.dimLevel[t].equals(comparableLevels.get(j))) {
                        levelIndex = t;
                        break;
                    }
                    ++t;
                }
                if (levelIndex == -1) {
                    return false;
                }
                if (!this.containMember(row.getLevelMembers()[levelIndex].getKeyValues(), (Object[])tuple[j])) {
                    matched = false;
                    break;
                }
            }
            ++j;
        }
        return matched;
    }

    private boolean containMember(Object[] levelkey, Object[] key) {
        Object[] memberKeys = levelkey;
        Object[] objectArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj.toString().equals(memberKeys[0].toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void clear() throws IOException {
        this.bufferedStructureArray.clear();
    }

    @Override
    public void close() throws IOException {
        this.bufferedStructureArray.close();
    }

    @Override
    public int getAggregationCount() {
        return this.aggregationRsFromCube.getAggregationCount();
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        return this.aggregationRsFromCube.getAggregationDataType(aggregationIndex);
    }

    @Override
    public int[] getAggregationDataType() {
        return this.aggregationRsFromCube.getAggregationDataType();
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return this.aggregationRsFromCube.getAggregationDefinition();
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        return this.aggregationRsFromCube.getAggregationIndex(name);
    }

    @Override
    public String getAggregationName(int index) {
        return this.aggregationRsFromCube.getAggregationName(index);
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        return this.resultObject.getAggregationValues()[aggregationIndex];
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.dimLevel;
    }

    @Override
    public String[][] getAttributeNames() {
        return this.aggregationRsFromCube.getAttributeNames();
    }

    @Override
    public IAggregationResultRow getCurrentRow() throws IOException {
        return this.resultObject;
    }

    @Override
    public String[][] getKeyNames() {
        return this.aggregationRsFromCube.getKeyNames();
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.aggregationRsFromCube.getLevel(levelIndex);
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (this.resultObject.getLevelMembers() == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1 || this.resultObject.getLevelMembers()[levelIndex] == null) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getAttributes()[attributeIndex];
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        return this.aggregationRsFromCube.getLevelAttributeColCount(levelIndex);
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        return this.aggregationRsFromCube.getLevelAttributeDataType(level, attributeName);
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        return this.aggregationRsFromCube.getLevelAttributeDataType(levelIndex, attributeName);
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.aggregationRsFromCube.getLevelAttributeDataType();
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        return this.aggregationRsFromCube.getLevelAttributeIndex(levelIndex, attributeName);
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        return this.aggregationRsFromCube.getLevelAttributeIndex(level, attributeName);
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        return this.aggregationRsFromCube.getLevelAttributes(levelIndex);
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.aggregationRsFromCube.getLevelAttributes();
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        return this.aggregationRsFromCube.getLevelAttributesValue(levelIndex);
    }

    @Override
    public int getLevelCount() {
        return this.aggregationRsFromCube.getLevelCount();
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        return this.aggregationRsFromCube.getLevelIndex(level);
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        return this.aggregationRsFromCube.getLevelKeyColCount(levelIndex);
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        return this.aggregationRsFromCube.getLevelKeyDataType(level, keyName);
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        return this.aggregationRsFromCube.getLevelKeyDataType(levelIndex, keyName);
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.aggregationRsFromCube.getLevelKeyDataType();
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        return this.aggregationRsFromCube.getLevelKeyIndex(levelIndex, keyName);
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        return this.aggregationRsFromCube.getLevelKeyIndex(level, keyName);
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.aggregationRsFromCube.getLevelKeyName(levelIndex, keyIndex);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        if (this.resultObject.getLevelMembers()[levelIndex] == null || levelIndex < 0 || levelIndex > this.resultObject.getLevelMembers().length - 1) {
            return null;
        }
        return this.resultObject.getLevelMembers()[levelIndex].getKeyValues();
    }

    @Override
    public String[][] getLevelKeys() {
        return this.aggregationRsFromCube.getLevelKeys();
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public int getSortType(int levelIndex) {
        return this.aggregationRsFromCube.getSortType(levelIndex);
    }

    @Override
    public int[] getSortType() {
        return this.aggregationRsFromCube.getSortType();
    }

    @Override
    public int length() {
        return this.bufferedStructureArray.size();
    }

    @Override
    public void seek(int index) throws IOException {
        if (index >= this.bufferedStructureArray.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.bufferedStructureArray.size());
        }
        this.currentPosition = index;
        this.resultObject = (IAggregationResultRow)this.bufferedStructureArray.get(index);
    }
}

