/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.ArchiveInputFile;
import org.eclipse.birt.data.engine.impl.index.ArchiveOutputFile;
import org.eclipse.birt.data.engine.impl.index.BTreeSerializerUtil;
import org.eclipse.birt.data.engine.impl.index.CompareHintsComparator;
import org.eclipse.birt.data.engine.impl.index.IDataSetIndex;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.impl.index.IntegerSerializer;
import org.eclipse.birt.data.engine.impl.index.JavaSerializer;
import org.eclipse.birt.data.engine.impl.index.KeyRowID;
import org.eclipse.birt.data.engine.olap.data.util.DataType;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIndex
implements IIndexSerializer,
IDataSetIndex {
    private BTree<Object, Integer> btree = null;
    private DiskSortedStack sortedKeyRowID = null;
    private BTreeSerializer serializer = null;
    private Class keyDataType = null;
    private long memoryBufferSize = 0L;
    private final int BTREE_CACHE_SIZE = 200;
    private ArchiveInputFile inputFile = null;
    private CompareHints compareHints = null;

    public BTreeIndex(long memoryBufferSize, String indexName, StreamManager manager, Class keyDataType, CompareHints compareHints) throws DataException {
        this.serializer = BTreeSerializerUtil.createSerializer(keyDataType);
        this.compareHints = compareHints;
        try {
            this.btree = BTreeIndex.createBTree(new ArchiveOutputFile(manager.getDocWriter(), manager.getOutStreamName(indexName)), 200, this.serializer, compareHints);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        this.keyDataType = keyDataType;
        this.memoryBufferSize = memoryBufferSize;
    }

    public BTreeIndex(String indexName, IDocArchiveReader reader, Class keyDataType, ClassLoader classLoader) throws DataException {
        this.serializer = BTreeSerializerUtil.createSerializer(keyDataType);
        if (this.serializer instanceof JavaSerializer) {
            ((JavaSerializer)this.serializer).setClassLoader(classLoader);
        }
        try {
            this.inputFile = new ArchiveInputFile(reader, indexName);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        this.keyDataType = keyDataType;
    }

    private static BTree<Object, Integer> createBTree(ArchiveOutputFile file, int cacheSize, BTreeSerializer serializer, CompareHints compareHints) throws DataException {
        BTreeOption option = new BTreeOption();
        option.setKeySerializer(serializer);
        option.setCacheSize(cacheSize);
        option.setHasValue(true);
        option.setAllowDuplicate(true);
        option.setAllowNullKey(true);
        option.setReadOnly(false);
        option.setValueSerializer(new IntegerSerializer());
        option.setValueSize(4);
        option.setFile(file);
        if (compareHints != null) {
            CompareHintsComparator comparator = new CompareHintsComparator(compareHints);
            option.setComparator(comparator);
        }
        try {
            return new BTree<Object, Integer>(option);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    public void setCompareHints(CompareHints compareHints) {
        this.compareHints = compareHints;
    }

    private static BTree<Object, Integer> createBTree(ArchiveInputFile file, int cacheSize, BTreeSerializer serializer, CompareHints compareHints) throws DataException {
        BTreeOption option = new BTreeOption();
        option.setKeySerializer(serializer);
        option.setCacheSize(cacheSize);
        option.setHasValue(true);
        option.setAllowDuplicate(true);
        option.setAllowNullKey(true);
        option.setReadOnly(true);
        option.setValueSerializer(new IntegerSerializer());
        option.setValueSize(4);
        option.setFile(file);
        if (compareHints != null) {
            CompareHintsComparator comparator = new CompareHintsComparator(compareHints);
            option.setComparator(comparator);
        }
        try {
            return new BTree<Object, Integer>(option);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void close() throws DataException {
        try {
            if (this.sortedKeyRowID != null) {
                this.insertToBTree();
            }
            if (this.btree != null) {
                this.btree.close();
            }
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private void insertToBTree() throws DataException {
        try {
            ArrayList<Integer> rowIDList = new ArrayList<Integer>();
            KeyRowID keyRowID = (KeyRowID)this.sortedKeyRowID.pop();
            boolean isFirst = true;
            Object lastKey = null;
            while (keyRowID != null) {
                if (isFirst) {
                    lastKey = keyRowID.key;
                    rowIDList.add(keyRowID.rowID);
                    isFirst = false;
                } else if (BTreeIndex.equals(lastKey, keyRowID.key) && rowIDList.size() < 1000) {
                    rowIDList.add(keyRowID.rowID);
                } else {
                    this.btree.insert(lastKey, (Integer[])rowIDList.toArray(new Integer[0]));
                    lastKey = keyRowID.key;
                    rowIDList.clear();
                    rowIDList.add(keyRowID.rowID);
                }
                keyRowID = (KeyRowID)this.sortedKeyRowID.pop();
            }
            if (rowIDList.size() > 0) {
                this.btree.insert(lastKey, (Integer[])rowIDList.toArray(new Integer[0]));
            }
            this.sortedKeyRowID.close();
            this.sortedKeyRowID = null;
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Object put(Object o1, Object o2) throws DataException {
        if (this.sortedKeyRowID == null) {
            int cacheSize = 10000;
            IStructureCreator keyRowIDCreator = KeyRowID.getCreator(this.compareHints);
            if (this.memoryBufferSize != 0L) {
                cacheSize = (int)(this.memoryBufferSize / (long)(SizeOfUtil.sizeOf(DataType.getDataType(this.keyDataType)) + 16 + 4));
                this.sortedKeyRowID = new DiskSortedStack(cacheSize, false, false, keyRowIDCreator);
            } else {
                this.sortedKeyRowID = new DiskSortedStack(cacheSize, false, false, keyRowIDCreator);
                this.sortedKeyRowID.setUseMemoryOnly(true);
            }
        }
        try {
            KeyRowID keyRowID = new KeyRowID(o1, (Integer)o2);
            keyRowID.compareHints = this.compareHints;
            this.sortedKeyRowID.push(keyRowID);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Integer> getKeyIndex(Object key, int filterType) throws DataException {
        List candidate;
        BTreeIndex bTreeIndex = this;
        synchronized (bTreeIndex) {
            if (this.btree == null) {
                this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer, this.compareHints);
            }
        }
        if (this.sortedKeyRowID != null) {
            this.insertToBTree();
            try {
                this.sortedKeyRowID.close();
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
            this.sortedKeyRowID = null;
        }
        if (filterType != 1 && filterType != 22 && filterType != 5 && filterType != 6 && filterType != 4 && filterType != 3 && filterType != 7) {
            throw new UnsupportedOperationException();
        }
        if (filterType == 1) {
            return this.getKeyIndex(key);
        }
        if (filterType == 22) {
            candidate = (List)key;
            HashSet<Integer> result = new HashSet<Integer>();
            for (Object eachKey : candidate) {
                result.addAll(this.getKeyIndex(eachKey));
            }
            return result;
        }
        if (filterType == 5) {
            return this.getGreater(key, true);
        }
        if (filterType == 6) {
            return this.getGreater(key, false);
        }
        if (filterType == 4) {
            return this.getLess(key, true);
        }
        if (filterType == 3) {
            return this.getLess(key, false);
        }
        if (filterType == 7) {
            candidate = (List)key;
            return this.getBetween(candidate.get(0), candidate.get(1));
        }
        return new HashSet<Integer>();
    }

    private Set<Integer> getBetween(Object key1, Object key2) throws DataException {
        Object max;
        Object min;
        if (ScriptEvalUtil.compare(key1, key2, this.compareHints) <= 0) {
            min = key1;
            max = key2;
        } else {
            min = key2;
            max = key1;
        }
        try {
            min = DataTypeUtil.convert(min, this.keyDataType);
            max = DataTypeUtil.convert(max, this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        BTreeCursor<Object, Integer> bCursor = this.btree.createCursor();
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            if (!bCursor.first()) {
                HashSet<Integer> hashSet = result;
                return hashSet;
            }
            if (ScriptEvalUtil.compare(bCursor.getKey(), min, this.compareHints) <= 0) {
                bCursor.moveTo(min);
                if (ScriptEvalUtil.compare(bCursor.getKey(), max, this.compareHints) > 0) {
                    HashSet<Integer> hashSet = result;
                    return hashSet;
                }
                if (ScriptEvalUtil.compare(bCursor.getKey(), min, this.compareHints) >= 0) {
                    result.addAll(bCursor.getValues());
                }
            } else {
                bCursor.beforeFirst();
            }
            while (bCursor.next()) {
                if (ScriptEvalUtil.compare(bCursor.getKey(), max, this.compareHints) > 0) {
                    HashSet<Integer> hashSet = result;
                    return hashSet;
                }
                try {
                    result.addAll(bCursor.getValues());
                }
                catch (IOException e) {
                    throw new DataException(e.getLocalizedMessage(), e);
                }
            }
        }
        finally {
            bCursor.close();
        }
        return result;
    }

    private Set<Integer> getGreater(Object key, boolean includeKey) throws DataException {
        try {
            key = DataTypeUtil.convert(key, this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        BTreeCursor<Object, Integer> bCursor = this.btree.createCursor();
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            if (!bCursor.first()) {
                HashSet<Integer> hashSet = result;
                return hashSet;
            }
            try {
                if (bCursor.getKey() != null && ScriptEvalUtil.compare(bCursor.getKey(), key, this.compareHints) > 0) {
                    bCursor.beforeFirst();
                } else {
                    bCursor.moveTo(key);
                    int cr = ScriptEvalUtil.compare(bCursor.getKey(), key, this.compareHints);
                    if (includeKey && cr == 0 || cr > 0) {
                        result.addAll(bCursor.getValues());
                    }
                }
                while (bCursor.next()) {
                    result.addAll(bCursor.getValues());
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            bCursor.close();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Set<Integer> getLess(Object key, boolean includeKey) throws DataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<Integer> getKeyIndex(Object key) throws DataException {
        HashSet<Integer> set = new HashSet<Integer>();
        Collection<Integer> rowID = null;
        try {
            key = DataTypeUtil.convert(key, this.keyDataType);
        }
        catch (BirtException e1) {
            throw DataException.wrap(e1);
        }
        try {
            rowID = this.btree.getValues(key);
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
        if (rowID != null) {
            set.addAll(rowID);
        }
        return set;
    }

    @Override
    public boolean supportFilter(int filterType) throws DataException {
        return filterType == 1 || filterType == 22 || filterType == 5 || filterType == 6 || filterType == 4 || filterType == 3 || filterType == 7;
    }

    @Override
    public Object[] getAllKeyValues() throws DataException {
        if (this.btree == null) {
            this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer, this.compareHints);
        }
        BTreeCursor<Object, Integer> bCursor = this.btree.createCursor();
        ArrayList<Object> key = new ArrayList<Object>();
        try {
            try {
                while (bCursor.next()) {
                    key.add(bCursor.getKey());
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            bCursor.close();
        }
        return key.toArray();
    }

    @Override
    public Set<Integer> getAllKeyRows() throws DataException {
        if (this.btree == null) {
            this.btree = BTreeIndex.createBTree(this.inputFile, 200, this.serializer, this.compareHints);
        }
        BTreeCursor<Object, Integer> bCursor = this.btree.createCursor();
        ArrayList<Integer> keyRow = new ArrayList<Integer>();
        try {
            try {
                while (bCursor.next()) {
                    keyRow.add(bCursor.getValue());
                }
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            bCursor.close();
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(keyRow);
        return set;
    }
}

