/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.ICacheable;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.FilterPrepareUtil;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;

public class EngineExecutionHints
implements IEngineExecutionHints {
    private Set cachedDataSetNames;
    private List<IDataQueryDefinition> queryDefns = new ArrayList<IDataQueryDefinition>();

    EngineExecutionHints() {
        this.cachedDataSetNames = new HashSet();
    }

    void populateCachedDataSets(DataEngineImpl dataEngine, IDataQueryDefinition[] qds) throws DataException {
        if (qds != null) {
            this.queryDefns.addAll(Arrays.asList(qds));
            ArrayList temp = new ArrayList();
            ArrayList temp2 = new ArrayList();
            this.cachedDataSetNames.clear();
            for (IDataQueryDefinition query : this.queryDefns) {
                IQueryDefinition qd;
                String dataSetName;
                if (query instanceof IQueryDefinition && (dataSetName = (qd = (IQueryDefinition)query).getDataSetName()) != null) {
                    int i;
                    IBaseDataSetDesign design = dataEngine.getDataSetDesign(dataSetName);
                    if (design instanceof ICacheable) {
                        this.populateDataSetNames(dataEngine.getDataSetDesign(dataSetName), dataEngine, temp2);
                    }
                    if (qd.getParentQuery() != null && qd.getInputParamBindings().size() == 0) {
                        i = 0;
                        while (i < temp2.size()) {
                            if (((BaseDataSetDesign)dataEngine.getDataSetDesign(temp2.get(i).toString())).needCache()) {
                                this.cachedDataSetNames.add(temp2.get(i));
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < temp2.size()) {
                        if (((BaseDataSetDesign)dataEngine.getDataSetDesign(temp2.get(i).toString())).needCache()) {
                            temp.add(temp2.get(i));
                        }
                        ++i;
                    }
                }
                temp2.clear();
            }
            HashSet tempSet = new HashSet();
            int i = 0;
            while (i < temp.size()) {
                if (tempSet.contains(temp.get(i))) {
                    this.cachedDataSetNames.add(temp.get(i));
                } else {
                    tempSet.add(temp.get(i));
                }
                ++i;
            }
            for (IDataQueryDefinition query : this.queryDefns) {
                IBaseDataSetDesign dataSet;
                IQueryDefinition q;
                String dataSetName;
                if (!(query instanceof IQueryDefinition) || (dataSetName = (q = (IQueryDefinition)query).getDataSetName()) == null || !this.cachedDataSetNames.contains(dataSetName) || !((dataSet = dataEngine.getDataSetDesign(dataSetName)) instanceof IOdaDataSetDesign)) continue;
                IBaseDataSourceDesign source = dataEngine.getDataSourceDesign(dataSet.getDataSourceName());
                boolean supportInExtensionOnly = FilterPrepareUtil.containsExternalFilter(((IQueryDefinition)query).getFilters(), ((IOdaDataSetDesign)dataSet).getExtensionID(), ((IOdaDataSourceDesign)source).getExtensionID());
                if (!supportInExtensionOnly) continue;
                this.cachedDataSetNames.remove(dataSet.getName());
            }
        }
    }

    private void populateDataSetNames(IBaseDataSetDesign design, DataEngineImpl engine, List names) throws DataException {
        if (design == null) {
            return;
        }
        names.add(design.getName());
        if (design instanceof IJointDataSetDesign) {
            IJointDataSetDesign jointDesign = (IJointDataSetDesign)design;
            this.populateDataSetNames(engine.getDataSetDesign(jointDesign.getLeftDataSetDesignQulifiedName()), engine, names);
            this.populateDataSetNames(engine.getDataSetDesign(jointDesign.getRightDataSetDesignQulifiedName()), engine, names);
        }
    }

    public boolean needCacheDataSet(String dataSetName) {
        return this.cachedDataSetNames.contains(dataSetName);
    }
}

