/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.style;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Style;
import org.eclipse.birt.chart.model.attribute.StyleMap;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.style.BaseStyleProcessor;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.birt.chart.style.SimpleStyle;

public final class SimpleProcessor
extends BaseStyleProcessor {
    private static final SimpleStyle defaultStyle;
    private static SimpleProcessor instance;
    private static final IGObjectFactory goFactory;

    static {
        goFactory = GObjectFactory.instance();
        TextAlignment ta = goFactory.createTextAlignment();
        FontDefinition font = goFactory.createFontDefinition("SansSerif", 12.0f, false, false, false, false, false, 0.0, ta);
        defaultStyle = new SimpleStyle(font, goFactory.BLACK(), null, null, null);
    }

    public static synchronized SimpleProcessor instance() {
        if (instance == null) {
            instance = new SimpleProcessor();
        }
        return instance;
    }

    private SimpleProcessor() {
    }

    public IStyle getStyle(Chart model, StyledComponent name) {
        if (model != null && model.getStyles().size() > 0) {
            for (StyleMap sm : model.getStyles()) {
                if (!sm.getComponentName().equals((Object)name)) continue;
                Style ss = sm.getStyle();
                SimpleStyle rt = new SimpleStyle(defaultStyle);
                rt.setFont(goFactory.copyOf(ss.getFont()));
                if (ss.getColor() != null) {
                    rt.setColor(goFactory.copyOf(ss.getColor()));
                }
                if (ss.getBackgroundColor() != null) {
                    rt.setBackgroundColor(goFactory.copyOf(ss.getBackgroundColor()));
                }
                if (ss.getBackgroundImage() != null) {
                    rt.setBackgroundImage(goFactory.copyOf(ss.getBackgroundImage()));
                }
                if (ss.getPadding() != null) {
                    rt.setPadding(goFactory.copyOf(ss.getPadding()));
                }
                return rt;
            }
        }
        return defaultStyle.copy();
    }
}

