/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class DataFormatter {
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern specialPatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private final DecimalFormatSymbols decimalSymbols;
    private final DateFormatSymbols dateSymbols;
    private final Format generalWholeNumFormat;
    private final Format generalDecimalNumFormat;
    private Format defaultNumFormat;
    private final Map<String, Format> formats;

    public DataFormatter() {
        this(Locale.getDefault());
    }

    public DataFormatter(Locale locale) {
        this.dateSymbols = new DateFormatSymbols(locale);
        this.decimalSymbols = new DecimalFormatSymbols(locale);
        this.generalWholeNumFormat = new DecimalFormat("#", this.decimalSymbols);
        this.generalDecimalNumFormat = new DecimalFormat("#.##########", this.decimalSymbols);
        this.formats = new HashMap<String, Format>();
        Format zipFormat = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", zipFormat);
        this.addFormat("00000-0000", zipFormat);
        Format phoneFormat = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("[<=9999999]###-####;(###) ###-####", phoneFormat);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("###-####;(###) ###-####", phoneFormat);
        Format ssnFormat = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", ssnFormat);
        this.addFormat("000-00-0000", ssnFormat);
    }

    private Format getFormat(Cell cell) {
        if (cell.getCellStyle() == null) {
            return null;
        }
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        if (formatStr == null || formatStr.trim().length() == 0) {
            return null;
        }
        return this.getFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format getFormat(double cellValue, int formatIndex, String formatStr) {
        Format format;
        if (formatStr.indexOf(59) != formatStr.lastIndexOf(59)) {
            int lastAt = formatStr.lastIndexOf(59);
            String zeroFormat = formatStr.substring(lastAt + 1);
            String normalFormat = formatStr.substring(0, lastAt);
            formatStr = cellValue == 0.0 ? zeroFormat : normalFormat;
        }
        if ((format = this.formats.get(formatStr)) != null) {
            return format;
        }
        if ("General".equals(formatStr) || "@".equals(formatStr)) {
            if (DataFormatter.isWholeNumber(cellValue)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        format = this.createFormat(cellValue, formatIndex, formatStr);
        this.formats.put(formatStr, format);
        return format;
    }

    public Format createFormat(Cell cell) {
        short formatIndex = cell.getCellStyle().getDataFormat();
        String formatStr = cell.getCellStyle().getDataFormatString();
        return this.createFormat(cell.getNumericCellValue(), formatIndex, formatStr);
    }

    private Format createFormat(double cellValue, int formatIndex, String sFormat) {
        String nFormatStr;
        String colour;
        int at;
        String formatStr = sFormat;
        Matcher colourM = colorPattern.matcher(formatStr);
        while (colourM.find() && (at = formatStr.indexOf(colour = colourM.group())) != -1 && !(nFormatStr = formatStr.substring(0, at) + formatStr.substring(at + colour.length())).equals(formatStr)) {
            formatStr = nFormatStr;
            colourM = colorPattern.matcher(formatStr);
        }
        Matcher m = specialPatternGroup.matcher(formatStr);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(symbol.substring(0, symbol.indexOf(36)));
                sb.append('\\');
                sb.append(symbol.substring(symbol.indexOf(36), symbol.length()));
                symbol = sb.toString();
            }
            formatStr = m.replaceAll(symbol);
            m = specialPatternGroup.matcher(formatStr);
        }
        if (formatStr == null || formatStr.trim().length() == 0) {
            return this.getDefaultFormat(cellValue);
        }
        if (DateUtil.isADateFormat(formatIndex, formatStr) && DateUtil.isValidExcelDate(cellValue)) {
            return this.createDateFormat(formatStr, cellValue);
        }
        if (numPattern.matcher(formatStr).find()) {
            return this.createNumberFormat(formatStr, cellValue);
        }
        return null;
    }

    private Format createDateFormat(String pFormatStr, double cellValue) {
        String formatStr = pFormatStr;
        formatStr = formatStr.replaceAll("\\\\-", "-");
        formatStr = formatStr.replaceAll("\\\\,", ",");
        formatStr = formatStr.replaceAll("\\\\ ", " ");
        formatStr = formatStr.replaceAll("\\\\/", "/");
        formatStr = formatStr.replaceAll(";@", "");
        formatStr = formatStr.replaceAll("\"/\"", "/");
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(formatStr);
        while (amPmMatcher.find()) {
            formatStr = amPmMatcher.replaceAll("@");
            hasAmPm = true;
            amPmMatcher = amPmPattern.matcher(formatStr);
        }
        Matcher dateMatcher = daysAsText.matcher(formatStr = formatStr.replaceAll("@", "a"));
        if (dateMatcher.find()) {
            String match = dateMatcher.group(0);
            formatStr = dateMatcher.replaceAll(match.toUpperCase().replaceAll("D", "E"));
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = formatStr.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        for (int j = 0; j < chars.length; ++j) {
            char c = chars[j];
            if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                    continue;
                }
                sb.append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(sb.length() - 1);
                    continue;
                }
                sb.append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                sb.append('s');
                for (int i = 0; i < ms.size(); ++i) {
                    int index = (Integer)ms.get(i);
                    if (sb.charAt(index) != 'M') continue;
                    sb.replace(index, index + 1, "m");
                }
                mIsMonth = true;
                ms.clear();
                continue;
            }
            if (Character.isLetter(c)) {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    sb.append('d');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        formatStr = sb.toString();
        try {
            return new ExcelStyleDateFormatter(formatStr, this.dateSymbols);
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private Format createNumberFormat(String formatStr, double cellValue) {
        char c;
        int i;
        StringBuffer sb = new StringBuffer(formatStr);
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c != '_' && c != '*' || i > 0 && sb.charAt(i - 1) == '\\') continue;
            if (i < sb.length() - 1) {
                sb.deleteCharAt(i + 1);
            }
            sb.deleteCharAt(i);
        }
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '+' || i <= 0 || sb.charAt(i - 1) != 'E') continue;
            sb.deleteCharAt(i);
            --i;
        }
        try {
            DecimalFormat df = new DecimalFormat(sb.toString(), this.decimalSymbols);
            DataFormatter.setExcelStyleRoundingMode(df);
            return df;
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    public Format getDefaultFormat(Cell cell) {
        return this.getDefaultFormat(cell.getNumericCellValue());
    }

    private Format getDefaultFormat(double cellValue) {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (DataFormatter.isWholeNumber(cellValue)) {
            return this.generalWholeNumFormat;
        }
        return this.generalDecimalNumFormat;
    }

    private String performDateFormatting(Date d, Format dateFormat) {
        if (dateFormat != null) {
            return dateFormat.format(d);
        }
        return d.toString();
    }

    private String getFormattedDateString(Cell cell) {
        Format dateFormat = this.getFormat(cell);
        if (dateFormat instanceof ExcelStyleDateFormatter) {
            ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(cell.getNumericCellValue());
        }
        Date d = cell.getDateCellValue();
        return this.performDateFormatting(d, dateFormat);
    }

    private String getFormattedNumberString(Cell cell) {
        Format numberFormat = this.getFormat(cell);
        double d = cell.getNumericCellValue();
        if (numberFormat == null) {
            return String.valueOf(d);
        }
        return numberFormat.format(new Double(d));
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString) {
        return this.formatRawCellContents(value, formatIndex, formatString, false);
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
        if (DateUtil.isADateFormat(formatIndex, formatString) && DateUtil.isValidExcelDate(value)) {
            Format dateFormat = this.getFormat(value, formatIndex, formatString);
            if (dateFormat instanceof ExcelStyleDateFormatter) {
                ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(value);
            }
            Date d = DateUtil.getJavaDate(value, use1904Windowing);
            return this.performDateFormatting(d, dateFormat);
        }
        Format numberFormat = this.getFormat(value, formatIndex, formatString);
        if (numberFormat == null) {
            return String.valueOf(value);
        }
        return numberFormat.format(new Double(value));
    }

    public String formatCellValue(Cell cell) {
        return this.formatCellValue(cell, null);
    }

    public String formatCellValue(Cell cell, FormulaEvaluator evaluator) {
        if (cell == null) {
            return "";
        }
        int cellType = cell.getCellType();
        if (cellType == 2) {
            if (evaluator == null) {
                return cell.getCellFormula();
            }
            cellType = evaluator.evaluateFormulaCell(cell);
        }
        switch (cellType) {
            case 0: {
                if (DateUtil.isCellDateFormatted(cell)) {
                    return this.getFormattedDateString(cell);
                }
                return this.getFormattedNumberString(cell);
            }
            case 1: {
                return cell.getRichStringCellValue().getString();
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 3: {
                return "";
            }
        }
        throw new RuntimeException("Unexpected celltype (" + cellType + ")");
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry<String, Format> entry : this.formats.entrySet()) {
            if (entry.getValue() != this.generalDecimalNumFormat && entry.getValue() != this.generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormat result = new DecimalFormat(fmt);
        result.setParseIntegerOnly(true);
        return result;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format) {
        try {
            Method srm = format.getClass().getMethod("setRoundingMode", RoundingMode.class);
            srm.invoke((Object)format, new Object[]{RoundingMode.HALF_UP});
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Unable to set rounding mode", iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Unable to set rounding mode", ite);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1 != null && seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2 != null && seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 3)).append('-');
            sb.append(result.substring(3, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }
}

