/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentElementInfo {
    private DesignElement element;
    private PropertyDefn propDefn;
    private List<Step> path = null;
    private boolean enablePath = false;

    public ContentElementInfo(DesignElement element, PropertyDefn propDefn) {
        this.element = element;
        this.propDefn = propDefn;
    }

    public ContentElementInfo(boolean enablePath) {
        this.enablePath = enablePath;
        this.path = new ArrayList<Step>();
    }

    public DesignElement getElement() {
        if (this.element != null) {
            return this.element;
        }
        return null;
    }

    public String getPropName() {
        if (this.propDefn != null) {
            return this.propDefn.getName();
        }
        if (this.path.isEmpty()) {
            return null;
        }
        Step topStep = this.path.get(this.path.size() - 1);
        this.propDefn = topStep.stepPropDefn;
        return this.propDefn.getName();
    }

    public void pushStep(PropertyDefn stepPropDefn, int index) {
        if (this.enablePath) {
            this.path.add(new Step(stepPropDefn, index));
        }
    }

    public void setTopElement(DesignElement topElement) {
        assert (!(topElement instanceof ContentElement));
        this.element = topElement;
    }

    public List<Step> stepIterator() {
        if (this.path == null) {
            return Collections.emptyList();
        }
        return this.path;
    }

    public void copyPath(ContentElementInfo target) {
        if (target == null) {
            return;
        }
        this.path = target.path;
    }

    static class Step {
        protected PropertyDefn stepPropDefn;
        protected int index = -1;

        Step(PropertyDefn propDefn, int index) {
            this.stepPropDefn = propDefn;
            this.index = index;
        }
    }
}

