/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.ValidationRecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Hierarchy;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleRecord
extends AbstractElementRecord {
    protected ContentElementInfo eventTarget;

    @Override
    public void execute() {
        this.perform(false);
    }

    @Override
    public void undo() {
        this.perform(true);
    }

    @Override
    public void redo() {
        this.perform(false);
    }

    protected abstract void perform(boolean var1);

    @Override
    public void rollback() {
        this.undo();
        this.setState(2);
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        DesignElement element = this.getTarget();
        assert (element != null);
        if (element.getRoot() == null) {
            return Collections.emptyList();
        }
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        retList.addAll(super.getPostTasks());
        retList.add(new ValidationRecordTask(element.getRoot()));
        return retList;
    }

    public void setEventTarget(ContentElementInfo eventTarget) {
        this.eventTarget = eventTarget;
    }

    protected void updateSharedDimension(Module module, DesignElement target) {
        DesignElement container = target;
        if (container instanceof Dimension || container instanceof Hierarchy || container instanceof Level) {
            while (container != null) {
                List<BackRef> refList;
                if (!(container instanceof Dimension)) {
                    container = container.getContainer();
                    continue;
                }
                Dimension dimension = (Dimension)container;
                if (!(dimension.getContainer() instanceof Module) || (refList = dimension.getClientList()) == null) break;
                for (BackRef ref : refList) {
                    DesignElement client = ref.getElement();
                    String propName = ref.getPropertyName();
                    if (!(client instanceof TabularDimension) || !"internalDimensionRef".equals(propName)) continue;
                    ((TabularDimension)client).updateLayout(module);
                }
            }
        }
    }

    protected void sendEventToSharedDimension(DesignElement target, List<RecordTask> retValue, NotificationEvent event) {
        DesignElement e = target;
        if (e instanceof Dimension || e instanceof Hierarchy || e instanceof Level) {
            while (e != null) {
                List<BackRef> refList;
                if (!(e instanceof Dimension)) {
                    e = e.getContainer();
                    continue;
                }
                Dimension shareDimension = (Dimension)e;
                if (!(shareDimension.getContainer() instanceof Module) || (refList = shareDimension.getClientList()) == null) break;
                for (BackRef ref : refList) {
                    DesignElement client = ref.getElement();
                    String propName = ref.getPropertyName();
                    if (!(client instanceof TabularDimension) || !"internalDimensionRef".equals(propName)) continue;
                    retValue.add(new NotificationRecordTask(client, event));
                }
            }
        }
    }
}

