/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.content.wrap;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.internal.content.wrap.AbstractContentWrapper;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class CellContentWrapper
extends AbstractContentWrapper
implements ICellContent {
    protected ICellContent cell;
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected int row = -1;

    public CellContentWrapper(ICellContent cell) {
        super(cell);
        this.cell = cell;
    }

    public int getRowSpan() {
        if (this.rowSpan != -1) {
            return this.rowSpan;
        }
        return this.cell.getRowSpan();
    }

    public int getColSpan() {
        if (this.colSpan != -1) {
            return this.colSpan;
        }
        return this.cell.getColSpan();
    }

    public int getColumn() {
        if (this.column != -1) {
            return this.column;
        }
        return this.cell.getColumn();
    }

    public int getRow() {
        if (this.row != -1) {
            return this.row;
        }
        return this.cell.getRow();
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitCell(this, value);
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public boolean getDisplayGroupIcon() {
        return this.cell.getDisplayGroupIcon();
    }

    public void setDisplayGroupIcon(boolean isStartOfGroup) {
        this.cell.setDisplayGroupIcon(isStartOfGroup);
    }

    public IColumn getColumnInstance() {
        return this.cell.getColumnInstance();
    }

    public IContent cloneContent(boolean isDeep) {
        if (isDeep) {
            throw new UnsupportedOperationException();
        }
        return new CellContentWrapper(this);
    }

    public boolean hasDiagonalLine() {
        return this.cell.hasDiagonalLine();
    }

    public void setDiagonalNumber(int diagonalNumber) {
        this.cell.setDiagonalNumber(diagonalNumber);
    }

    public int getDiagonalNumber() {
        return this.cell.getDiagonalNumber();
    }

    public void setDiagonalStyle(String diagonalStyle) {
        this.cell.setDiagonalStyle(diagonalStyle);
    }

    public String getDiagonalStyle() {
        return this.cell.getDiagonalStyle();
    }

    public void setDiagonalWidth(DimensionType diagonalWidth) {
        this.cell.setDiagonalWidth(diagonalWidth);
    }

    public DimensionType getDiagonalWidth() {
        return this.cell.getDiagonalWidth();
    }

    public void setDiagonalColor(String diagonalColor) {
        this.cell.setDiagonalColor(diagonalColor);
    }

    public String getDiagonalColor() {
        return this.cell.getDiagonalColor();
    }

    public void setAntidiagonalNumber(int antidiagonalNumber) {
        this.cell.setAntidiagonalNumber(antidiagonalNumber);
    }

    public int getAntidiagonalNumber() {
        return this.cell.getAntidiagonalNumber();
    }

    public void setAntidiagonalStyle(String antidiagonalStyle) {
        this.cell.setAntidiagonalStyle(antidiagonalStyle);
    }

    public String getAntidiagonalStyle() {
        return this.cell.getAntidiagonalStyle();
    }

    public void setAntidiagonalWidth(DimensionType antidiagonalWidth) {
        this.cell.setAntidiagonalWidth(antidiagonalWidth);
    }

    public DimensionType getAntidiagonalWidth() {
        return this.cell.getAntidiagonalWidth();
    }

    public void setAntidiagonalColor(String antidiagonalColor) {
        this.cell.setAntidiagonalColor(antidiagonalColor);
    }

    public String getAntidiagonalColor() {
        return this.cell.getAntidiagonalColor();
    }

    public String getHeaders() {
        return this.cell.getHeaders();
    }

    public String getScope() {
        return this.cell.getScope();
    }

    public void setHeaders(String headers) {
        this.cell.setHeaders(headers);
    }

    public String getDrop() {
        return this.cell.getScope();
    }

    public void setScope(String scope) {
        this.cell.setScope(scope);
    }

    public boolean repeatContent() {
        return this.cell.repeatContent();
    }

    public void setRepeatContent(boolean repeatContent) {
        this.cell.setRepeatContent(repeatContent);
    }
}

