/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.EnumSet;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelLimiter {
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private double maxWidth;
    private double maxHeight;
    private double wrapping;
    private boolean bSuccessed = true;

    public LabelLimiter(double maxWidth, double maxHeight, double wrapping) {
        this(maxWidth, maxHeight, wrapping, true);
    }

    private LabelLimiter(double maxWidth, double maxHeight, double wrapping, boolean bSuccessed) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.wrapping = wrapping;
        this.bSuccessed = bSuccessed;
    }

    public double computeWrapping(IDisplayServer xs, Label la) {
        return LabelLimiter.computeWrapping(xs, la, this);
    }

    public BoundingBox getBounding(BoundingBox bb) {
        if (bb == null) {
            bb = new BoundingBox(0, 0.0, 0.0, this.maxWidth, this.maxHeight, 0.0);
        }
        return bb;
    }

    public static final double computeWrapping(IDisplayServer xs, Label la, LabelLimiter lbLimit) {
        double dWrapping = 0.0;
        boolean bIsSWT = xs.getClass().getName().equals("org.eclipse.birt.chart.device.swt.SwtDisplayServer");
        double dSafe = bIsSWT ? 10 : 0;
        if (lbLimit != null) {
            double dScale = (double)xs.getDpiResolution() / 72.0;
            double fRotation = la.getCaption().getFont().getRotation();
            Insets insets = goFactory.scaleInsets(la.getInsets(), dScale);
            double dInsetsWidth = insets.getLeft() + insets.getRight();
            if (ChartUtil.mathEqual(fRotation, 0.0)) {
                dWrapping = Math.floor(lbLimit.maxWidth - dInsetsWidth) - dSafe;
            } else if (ChartUtil.mathEqual(fRotation, 90.0)) {
                dWrapping = Math.floor(lbLimit.maxHeight - dInsetsWidth) - dSafe;
            } else {
                double d;
                double b;
                if ((fRotation %= 180.0) < 0.0) {
                    fRotation += 180.0;
                }
                double rad = Math.toRadians(fRotation % 90.0);
                double tg = Math.tan(rad);
                double m = 1.0 - tg * tg;
                double r = 2.0 * tg / (1.0 + tg * tg);
                double wd1 = lbLimit.maxWidth;
                double ht1 = lbLimit.maxHeight;
                if (wd1 < ht1) {
                    if (tg < 1.0 && r < wd1 / ht1 || tg > 1.0 && r < wd1 / ht1) {
                        b = (wd1 - ht1 * tg) / m;
                        d = (ht1 - wd1 * tg) / m;
                    } else {
                        b = wd1 / 2.0;
                        d = b / tg;
                    }
                } else if (tg < 1.0 && r < ht1 / wd1 || tg > 1.0 && r < ht1 / wd1) {
                    b = (wd1 - ht1 * tg) / m;
                    d = (ht1 - wd1 * tg) / m;
                } else {
                    d = ht1 / 2.0;
                    b = d / tg;
                }
                double cos = Math.cos(rad);
                double wd2 = fRotation < 90.0 ? b / cos : d / cos;
                dWrapping = Math.floor(wd2) - dInsetsWidth - dSafe;
            }
            lbLimit.wrapping = dWrapping;
        }
        return dWrapping;
    }

    public LabelLimiter limitLabelSize(IChartComputation cComp, IDisplayServer xs, Label la) throws ChartException {
        return LabelLimiter.limitLabelSize(cComp, xs, la, this, EnumSet.noneOf(Option.class));
    }

    public LabelLimiter limitLabelSize(IChartComputation cComp, IDisplayServer xs, Label la, EnumSet<Option> options) throws ChartException {
        return LabelLimiter.limitLabelSize(cComp, xs, la, this, options);
    }

    public static final LabelLimiter limitLabelSize(IChartComputation cComp, IDisplayServer xs, Label la, LabelLimiter lbLimit, EnumSet<Option> options) throws ChartException {
        double wrapping;
        double maxHeight;
        double maxWidth;
        boolean bSuccessed = true;
        if (lbLimit != null) {
            EllipsisHelper eHelper = EllipsisHelper.simpleInstance(cComp, xs, la, null);
            if (eHelper.checkLabelEllipsis(la.getCaption().getValue(), lbLimit)) {
                maxWidth = eHelper.getTester().getWidth();
                maxHeight = eHelper.getTester().getHeight();
            } else {
                la.getCaption().setValue("");
                maxWidth = 0.0;
                maxHeight = 0.0;
                bSuccessed = false;
            }
            wrapping = lbLimit.getWrapping();
        } else {
            BoundingBox bb = cComp.computeLabelSize(xs, la, 0.0, null);
            maxWidth = bb.getWidth();
            maxHeight = bb.getHeight();
            wrapping = 0.0;
        }
        if (options.contains((Object)Option.FIX_WIDTH)) {
            maxWidth = lbLimit.maxWidth;
        }
        if (options.contains((Object)Option.FIX_HEIGHT)) {
            maxHeight = lbLimit.maxHeight;
        }
        return new LabelLimiter(maxWidth, maxHeight, wrapping, bSuccessed);
    }

    public final double getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
    }

    public final double getMaxHeight() {
        return this.maxHeight;
    }

    public final void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
    }

    public final double getWrapping() {
        return this.wrapping;
    }

    public final void setWrapping(double wrapping) {
        this.wrapping = wrapping;
    }

    public final boolean isSuccessed() {
        return this.bSuccessed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        FIX_WIDTH,
        FIX_HEIGHT;

    }
}

