/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.text.formatter;

import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Formattable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.TimeZone;
import sun.misc.FormattedFloatingDecimal;

public class PatternFormatter {
    public static Pattern compile(String pattern) {
        return PatternFormatter.compile(pattern, null);
    }

    public static Pattern compile(String pattern, ArgumentNameSpace namespace) {
        Pattern result = new Pattern(pattern, namespace);
        int start = 0;
        int end = 0;
        while (start < pattern.length()) {
            end = pattern.indexOf(37, start);
            if (end >= 0) {
                if (end > start) {
                    result.addElement(new StringElement(pattern.substring(start, end)));
                }
                ArgumentParser ap = new ArgumentParser(result.getPattern(), end, result.getNameSpace());
                result.addElement(ap.parse());
                start = ap.getEndArgumentPosition();
                continue;
            }
            end = pattern.length();
            if (end <= start) continue;
            result.addElement(new StringElement(pattern.substring(start, end)));
            break;
        }
        return result;
    }

    public static String format(String format, Object ... args) {
        return PatternFormatter.format(format, Locale.getDefault(), args);
    }

    public static String format(String format, Locale locale, Object ... args) {
        return PatternFormatter.format(PatternFormatter.compile(format), locale, args);
    }

    public static String format(Pattern pattern, Object ... args) {
        return PatternFormatter.format(pattern, Locale.getDefault(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Pattern pattern, Locale locale, Object ... args) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String[] array = new String[pattern.size()];
        int arrayLength = 0;
        int last = -1;
        int lasto = -1;
        for (int i = 0; i < pattern.size(); ++i) {
            PatternElement pe = pattern.getElements(i);
            int index = pe.index();
            switch (index) {
                case -2: {
                    array[i] = pe.format(null, locale);
                    break;
                }
                case -1: {
                    if (last < 0 || args != null && last > args.length - 1) {
                        throw new MissingFormatArgumentException(pe.toString());
                    }
                    array[i] = pe.format(args == null ? null : args[last], locale);
                    break;
                }
                case 0: {
                    last = ++lasto;
                    if (args != null && lasto > args.length - 1) {
                        throw new MissingFormatArgumentException(pe.toString());
                    }
                    array[i] = pe.format(args == null ? null : args[lasto], locale);
                    break;
                }
                default: {
                    last = index - 1;
                    if (args != null && last > args.length - 1) {
                        throw new MissingFormatArgumentException(pe.toString());
                    }
                    array[i] = pe.format(args == null ? null : args[last], locale);
                }
            }
            arrayLength += array[i] == null ? 0 : array[i].length();
            continue;
        }
        char[] result = new char[arrayLength];
        int resultPos = 0;
        for (String e : array) {
            e.getChars(0, e.length(), result, resultPos);
            resultPos += e.length();
        }
        return new String(result);
    }

    public static class CompositeArgumentNameSpace
    implements AttributeArgumentNameSpace,
    DetailedArgumentNameSpace {
        private String[] symbols = null;
        private Map<String, ArgumentNameSpace> namespaces = null;

        public CompositeArgumentNameSpace(ArgumentNameSpace ... ns) {
            this.symbols = this.mergeSymbols(ns);
        }

        private String[] mergeSymbols(ArgumentNameSpace ... ns) {
            this.namespaces = new HashMap<String, ArgumentNameSpace>();
            String[] result = null;
            int resultLength = 0;
            int newResultLength = 0;
            for (ArgumentNameSpace namespace : ns) {
                if (namespace instanceof IndexableArgumentNameSpace) {
                    throw new IllegalArgumentException("can't compose a namespace from an IndexArgumentNameSpace");
                }
                String[] toAdd = namespace.symbols();
                resultLength = result != null ? result.length : 0;
                newResultLength = resultLength + toAdd.length;
                String[] newResult = new String[newResultLength];
                if (result != null) {
                    System.arraycopy(result, 0, newResult, 0, result.length);
                }
                System.arraycopy(toAdd, 0, newResult, resultLength, toAdd.length);
                result = newResult;
                for (String symbol : toAdd) {
                    if (this.namespaces.containsKey(symbol)) {
                        throw new IllegalArgumentException("Conflicting symbol '" + symbol + "' on " + this);
                    }
                    this.namespaces.put(symbol, namespace);
                }
            }
            return result;
        }

        public String[] symbols() {
            return this.symbols;
        }

        public Conversion getConversion(String symbol) {
            ArgumentNameSpace ns = this.namespaces.get(symbol);
            if (ns == null) {
                return Conversion.STRING;
            }
            return ns.getConversion(symbol);
        }

        public Object getAtttribute(Object value, String symbol, Locale locale) {
            ArgumentNameSpace ns = this.namespaces.get(symbol);
            if (!(ns instanceof AttributeArgumentNameSpace)) {
                return value;
            }
            return ((AttributeArgumentNameSpace)ns).getAtttribute(value, symbol, locale);
        }

        public String getDateSeparator(String symbol) {
            ArgumentNameSpace ns = this.namespaces.get(symbol);
            if (ns == null) {
                return "";
            }
            return ns.getDateSeparator(symbol);
        }

        public ArgumentDetails getDetails(ArgumentDetails details, String symbol) {
            ArgumentNameSpace ns = this.namespaces.get(symbol);
            if (ns instanceof DetailedArgumentNameSpace) {
                return ((DetailedArgumentNameSpace)ns).getDetails(details, symbol);
            }
            return details;
        }

        public void use(String symbol) {
            ArgumentNameSpace ns = this.namespaces.get(symbol);
            if (ns != null) {
                ns.use(symbol);
            }
        }
    }

    public static class DefaultArgumentNameSpace
    implements ArgumentNameSpace {
        public String[] symbols() {
            Conversion[] c = Conversion.values();
            String[] result = new String[c.length];
            for (int i = 0; i < c.length; ++i) {
                result[i] = Character.valueOf(c[i].getChar()).toString();
            }
            return result;
        }

        public Conversion getConversion(String symbol) {
            return Conversion.parse(symbol.charAt(0));
        }

        public void use(String symbol) {
        }

        public String getDateSeparator(String symbol) {
            return "";
        }
    }

    public static class Flags {
        public static final Flags NONE = new Flags(0);
        public static final Flags LEFT_JUSTIFY = new Flags(1);
        public static final Flags UPPER = new Flags(2);
        public static final Flags ALTERNATE = new Flags(4);
        public static final Flags PLUS = new Flags(8);
        public static final Flags LEADING = new Flags(16);
        public static final Flags ZERO_PAD = new Flags(32);
        public static final Flags GROUP = new Flags(64);
        public static final Flags PARENTHESE = new Flags(128);
        private int value = 0;
        private boolean mutable = false;

        private Flags(int v) {
            this(v, false);
        }

        private Flags(int v, boolean mutable) {
            this.value = v;
            this.mutable = mutable;
        }

        public int getValue() {
            return this.value;
        }

        public boolean contains(Flags flag) {
            return (this.getValue() & flag.getValue()) == flag.getValue();
        }

        public Flags and(Flags flags) {
            if (!this.mutable) {
                return new Flags(this.getValue() | flags.getValue(), true);
            }
            this.value |= flags.getValue();
            return this;
        }

        public Flags remove(Flags flags) {
            if (!this.mutable) {
                return new Flags(this.getValue() & ~flags.getValue(), true);
            }
            this.value &= ~flags.getValue();
            return this;
        }

        public static Flags parse(String flags, Conversion conversion) {
            if (flags == null) {
                return NONE;
            }
            Flags result = NONE;
            block9: for (int i = 0; i < flags.length(); ++i) {
                char c = flags.charAt(i);
                switch (c) {
                    case '-': {
                        result = result.and(LEFT_JUSTIFY);
                        continue block9;
                    }
                    case '#': {
                        result = result.and(ALTERNATE);
                        continue block9;
                    }
                    case '+': {
                        result = result.and(PLUS);
                        continue block9;
                    }
                    case ' ': {
                        result = result.and(LEADING);
                        continue block9;
                    }
                    case '0': {
                        result = result.and(ZERO_PAD);
                        continue block9;
                    }
                    case ',': {
                        result = result.and(GROUP);
                        continue block9;
                    }
                    case '(': {
                        result = result.and(ALTERNATE);
                        continue block9;
                    }
                }
            }
            if (conversion.isUpper()) {
                result = result.and(UPPER);
            }
            return result;
        }
    }

    private static class ArgumentElement
    implements PatternElement {
        int argument_index = 0;
        ArgumentDetails argument_details = null;
        Conversion conversion = null;
        AttributeArgumentNameSpace nameSpace = null;
        String nameSpaceSymbol = null;
        Locale loc = null;
        DecimalFormatSymbols dfs = null;
        char groupSeparator = (char)32;
        char decimalSeparator = (char)46;
        char zero = (char)48;
        char[] buffer = null;
        Calendar calendar = null;
        DateFormatSymbols datefs = null;

        public ArgumentElement(int index, Conversion conversion, ArgumentDetails details) {
            this.argument_index = index;
            this.argument_details = details;
            this.conversion = conversion.getEffectiveConversion();
            switch (this.conversion) {
                case DECIMAL_FLOAT: 
                case GENERAL: 
                case SCIENTIFIC: {
                    this.buffer = new char[100];
                    break;
                }
                case DATE_TIME: {
                    this.calendar = Calendar.getInstance();
                    break;
                }
            }
        }

        public void setNameSpace(AttributeArgumentNameSpace nameSpace, String symbol) {
            this.nameSpace = nameSpace;
            this.nameSpaceSymbol = symbol;
        }

        public int index() {
            return this.argument_index;
        }

        public Flags getFlags() {
            return this.argument_details.getFlags();
        }

        public int getWidth() {
            return this.argument_details.getWidth();
        }

        public int getPrecision() {
            return this.argument_details.getPrecision();
        }

        public DateTimeConversion getDateTimeConversion() {
            return this.argument_details.getDateTimeConversion();
        }

        public String format(Object arg, Locale locale) {
            if (this.nameSpace != null) {
                arg = this.nameSpace.getAtttribute(arg, this.nameSpaceSymbol, locale);
            }
            switch (this.conversion) {
                case DATE_TIME: {
                    return this.formatDateTime(arg, locale);
                }
                case DECIMAL_INTEGER: 
                case OCTAL_INTEGER: 
                case HEXADECIMAL_INTEGER: {
                    return this.formatInteger(arg, locale);
                }
                case DECIMAL_FLOAT: 
                case GENERAL: 
                case SCIENTIFIC: 
                case HEXADECIMAL_FLOAT: {
                    return this.formatFloat(arg, locale);
                }
                case CHARACTER: {
                    return this.formatCharacter(arg, locale);
                }
                case BOOLEAN: {
                    return this.formatBoolean(arg, locale);
                }
                case STRING: {
                    return this.formatString(arg, locale);
                }
                case HASHCODE: {
                    return this.formatHashCode(arg, locale);
                }
            }
            return "";
        }

        private String formatInteger(Object arg, Locale locale) {
            if (arg == null) {
                return "null";
            }
            String result = null;
            if (arg instanceof Number) {
                long value = ((Number)arg).longValue();
                if (value < 0L && (this.conversion == Conversion.HEXADECIMAL_INTEGER || this.conversion == Conversion.OCTAL_INTEGER)) {
                    int bitSize = 0;
                    if (arg instanceof Integer) {
                        bitSize = 32;
                    } else if (arg instanceof Short) {
                        bitSize = 16;
                    } else if (arg instanceof Byte) {
                        bitSize = 8;
                    }
                    value += (long)(1 << bitSize);
                }
                result = this.formatInteger(value, locale);
            }
            if (result == null) {
                this.fail(arg);
            }
            return this.justify(result);
        }

        private String formatFloat(Object arg, Locale locale) {
            if (arg == null) {
                return "null";
            }
            String result = null;
            if (arg instanceof Number) {
                result = this.formatFloat(((Number)arg).doubleValue(), locale);
            }
            if (result == null) {
                this.fail(arg);
            }
            return this.justify(result);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String formatCharacter(Object arg, Locale locale) {
            if (arg == null) {
                return "null";
            }
            String result = null;
            if (arg instanceof Character) {
                result = ((Character)arg).toString();
            } else if (arg instanceof Byte) {
                byte b = (Byte)arg;
                if (!Character.isValidCodePoint(b)) throw new IllegalFormatCodePointException(b);
                result = new String(Character.toChars(b));
            } else if (arg instanceof Short) {
                short s = (Short)arg;
                if (!Character.isValidCodePoint(s)) throw new IllegalFormatCodePointException(s);
                result = new String(Character.toChars(s));
            } else if (arg instanceof Integer) {
                int i = (Integer)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                result = new String(Character.toChars(i));
            }
            if (result != null) return this.formatString(result, locale);
            this.fail(arg);
            return this.formatString(result, locale);
        }

        private String formatBoolean(Object arg, Locale locale) {
            String result = null;
            result = arg == null ? Boolean.FALSE.toString() : (arg instanceof Boolean ? this.formatString(((Boolean)arg).toString(), locale) : Boolean.TRUE.toString());
            return this.formatString(result, locale);
        }

        private String formatDateTime(Object arg, Locale locale) {
            if (arg == null) {
                return "null";
            }
            Calendar date = null;
            if (arg instanceof Number) {
                date = this.calendar;
                date.setTimeInMillis(((Number)arg).longValue());
            } else if (arg instanceof Date) {
                date = this.calendar;
                date.setTime((Date)arg);
            } else if (arg instanceof Calendar) {
                date = (Calendar)arg;
            }
            if (date == null) {
                this.fail(arg);
            }
            return this.formatDateTime(date, this.getDateTimeConversion(), locale);
        }

        private String formatDateTime(Calendar date, DateTimeConversion c, Locale locale) {
            switch (c) {
                case HOUR_OF_DAY_0: {
                    int hour = date.get(11);
                    return this.formatLocalizedNumber(Integer.toString(hour), false, 2, Flags.ZERO_PAD, locale);
                }
                case HOUR_0: {
                    int hour = date.get(10) + 1;
                    return this.formatLocalizedNumber(Integer.toString(hour), false, 2, Flags.ZERO_PAD, locale);
                }
                case HOUR_OF_DAY: {
                    int hour = date.get(11);
                    return Integer.toString(hour);
                }
                case HOUR: {
                    int hour = date.get(10) + 1;
                    return Integer.toString(hour);
                }
                case MINUTE: {
                    int minute = date.get(12);
                    return this.formatLocalizedNumber(Integer.toString(minute), false, 2, Flags.ZERO_PAD, locale);
                }
                case NANOSECOND: {
                    int nano = date.get(14) * 1000000;
                    return this.formatLocalizedNumber(Integer.toString(nano), false, 9, Flags.ZERO_PAD, locale);
                }
                case MILLISECOND: {
                    int milli = date.get(14);
                    return this.formatLocalizedNumber(Integer.toString(milli), false, 3, Flags.ZERO_PAD, locale);
                }
                case MILLISECOND_SINCE_EPOCH: {
                    long millis = date.getTimeInMillis();
                    return this.formatLocalizedNumber(Long.toString(millis), false, locale);
                }
                case AM_PM: {
                    DateFormatSymbols datefs = this.getDateFormatSymbols(locale);
                    String s = this.justify(datefs.getAmPmStrings()[date.get(9)]);
                    if (this.getFlags().contains(Flags.UPPER)) {
                        return s.toUpperCase(locale);
                    }
                    return s;
                }
                case SECONDS_SINCE_EPOCH: {
                    long seconds = date.getTimeInMillis() / 1000L;
                    return this.formatLocalizedNumber(Long.toString(seconds), false, locale);
                }
                case SECOND: {
                    int second = date.get(13);
                    return this.formatLocalizedNumber(Integer.toString(second), false, 2, Flags.ZERO_PAD, locale);
                }
                case TIME: {
                    String sHour = this.formatDateTime(date, DateTimeConversion.HOUR_OF_DAY_0, locale);
                    String sMinute = this.formatDateTime(date, DateTimeConversion.MINUTE, locale);
                    String sSeconde = this.formatDateTime(date, DateTimeConversion.SECOND, locale);
                    char[] result = new char[8];
                    sHour.getChars(0, 2, result, 0);
                    result[2] = 58;
                    sMinute.getChars(0, 2, result, 3);
                    result[5] = 58;
                    sSeconde.getChars(0, 2, result, 6);
                    return new String(result);
                }
                case ZONE_NUMERIC: {
                    int i = date.get(15);
                    String prefix = i < 0 ? "-" : "+";
                    i = Math.abs(i);
                    int min = i / 60000;
                    int offset = min / 60 * 100 + min % 60;
                    return this.formatLocalizedNumber(Integer.toString(offset), false, 4, Flags.ZERO_PAD, prefix, null, locale);
                }
                case ZONE: {
                    TimeZone tz = date.getTimeZone();
                    return tz.getDisplayName(date.get(16) != 0, 0, locale);
                }
                case NAME_OF_DAY_ABBREV: {
                    DateFormatSymbols datefs = this.getDateFormatSymbols(locale);
                    String s = this.justify(datefs.getShortWeekdays()[date.get(7)]);
                    if (this.getFlags().contains(Flags.UPPER)) {
                        return s.toUpperCase(locale);
                    }
                    return s;
                }
                case NAME_OF_DAY: {
                    DateFormatSymbols datefs = this.getDateFormatSymbols(locale);
                    String s = this.justify(datefs.getWeekdays()[date.get(7)]);
                    if (this.getFlags().contains(Flags.UPPER)) {
                        return s.toUpperCase(locale);
                    }
                    return s;
                }
                case NAME_OF_MONTH_ABBREV_X: 
                case NAME_OF_MONTH_ABBREV: {
                    DateFormatSymbols datefs = this.getDateFormatSymbols(locale);
                    String s = this.justify(datefs.getShortMonths()[date.get(2)]);
                    if (this.getFlags().contains(Flags.UPPER)) {
                        return s.toUpperCase(locale);
                    }
                    return s;
                }
                case NAME_OF_MONTH: {
                    DateFormatSymbols datefs = this.getDateFormatSymbols(locale);
                    String s = this.justify(datefs.getMonths()[date.get(2)]);
                    if (this.getFlags().contains(Flags.UPPER)) {
                        return s.toUpperCase(locale);
                    }
                    return s;
                }
                case CENTURY: {
                    int century = date.get(1) / 100;
                    return this.formatLocalizedNumber(Integer.toString(century), false, 2, Flags.ZERO_PAD, locale);
                }
                case DAY_OF_MONTH_0: {
                    int day = date.get(5);
                    return this.formatLocalizedNumber(Integer.toString(day), false, 2, Flags.ZERO_PAD, locale);
                }
                case DAY_OF_MONTH: {
                    int day = date.get(5);
                    return Integer.toString(day);
                }
                case DAY_OF_YEAR: {
                    int day = date.get(6);
                    return this.formatLocalizedNumber(Integer.toString(day), false, 3, Flags.ZERO_PAD, locale);
                }
                case MONTH: {
                    int month = date.get(2) + 1;
                    return this.formatLocalizedNumber(Integer.toString(month), false, 2, Flags.ZERO_PAD, locale);
                }
                case YEAR_2: {
                    int year = date.get(1);
                    return this.formatLocalizedNumber(Integer.toString(year), false, 4, Flags.ZERO_PAD, locale).substring(2);
                }
                case YEAR_4: {
                    int year = date.get(1);
                    return this.formatLocalizedNumber(Integer.toString(year), false, 4, Flags.ZERO_PAD, locale);
                }
                case TIME_12_HOUR: {
                    String sHour = this.formatDateTime(date, DateTimeConversion.HOUR_0, locale);
                    String sMinute = this.formatDateTime(date, DateTimeConversion.MINUTE, locale);
                    String sSeconde = this.formatDateTime(date, DateTimeConversion.SECOND, locale);
                    String sAP_AM = this.formatDateTime(date, DateTimeConversion.AM_PM, locale);
                    char[] result = new char[sHour.length() + sMinute.length() + sSeconde.length() + sAP_AM.length() + 3];
                    int offset = 0;
                    sHour.getChars(0, sHour.length(), result, offset);
                    offset += sHour.length();
                    result[offset++] = 58;
                    sMinute.getChars(0, sMinute.length(), result, offset);
                    offset += sMinute.length();
                    result[offset++] = 32;
                    sSeconde.getChars(0, sSeconde.length(), result, offset);
                    offset += sSeconde.length();
                    result[offset++] = 32;
                    sAP_AM.getChars(0, sAP_AM.length(), result, offset);
                    offset += sAP_AM.length();
                    return new String(result);
                }
                case TIME_24_HOUR: {
                    String sHour = this.formatDateTime(date, DateTimeConversion.HOUR_OF_DAY_0, locale);
                    String sMinute = this.formatDateTime(date, DateTimeConversion.MINUTE, locale);
                    char[] result = new char[5];
                    sHour.getChars(0, 2, result, 0);
                    result[2] = 58;
                    sMinute.getChars(0, 2, result, 3);
                    return new String(result);
                }
                case DATE_TIME: {
                    String sNameDay = this.formatDateTime(date, DateTimeConversion.NAME_OF_DAY_ABBREV, locale);
                    String sNameMonth = this.formatDateTime(date, DateTimeConversion.NAME_OF_MONTH_ABBREV, locale);
                    String sDay = this.formatDateTime(date, DateTimeConversion.DAY_OF_MONTH_0, locale);
                    String sTime = this.formatDateTime(date, DateTimeConversion.TIME, locale);
                    String sZone = this.formatDateTime(date, DateTimeConversion.ZONE, locale);
                    String sYear = this.formatDateTime(date, DateTimeConversion.YEAR_4, locale);
                    char[] result = new char[sNameDay.length() + sNameMonth.length() + sDay.length() + sTime.length() + sZone.length() + sYear.length() + 5];
                    int offset = 0;
                    sNameDay.getChars(0, sNameDay.length(), result, offset);
                    offset += sNameDay.length();
                    result[offset++] = 32;
                    sNameMonth.getChars(0, sNameMonth.length(), result, offset);
                    offset += sNameMonth.length();
                    result[offset++] = 32;
                    sDay.getChars(0, sDay.length(), result, offset);
                    offset += sDay.length();
                    result[offset++] = 32;
                    sTime.getChars(0, sTime.length(), result, offset);
                    offset += sTime.length();
                    result[offset++] = 32;
                    sZone.getChars(0, sZone.length(), result, offset);
                    offset += sZone.length();
                    result[offset++] = 32;
                    sYear.getChars(0, sYear.length(), result, offset);
                    offset += sYear.length();
                    return new String(result);
                }
                case DATE: {
                    String sMonth = this.formatDateTime(date, DateTimeConversion.MONTH, locale);
                    String sDay = this.formatDateTime(date, DateTimeConversion.DAY_OF_MONTH_0, locale);
                    String sYear = this.formatDateTime(date, DateTimeConversion.YEAR_2, locale);
                    char[] result = new char[8];
                    sMonth.getChars(0, 2, result, 0);
                    result[2] = 47;
                    sDay.getChars(0, 2, result, 3);
                    result[5] = 47;
                    sYear.getChars(0, 2, result, 6);
                    return new String(result);
                }
                case ISO_STANDARD_DATE: {
                    String sYear = this.formatDateTime(date, DateTimeConversion.YEAR_4, locale);
                    String sMonth = this.formatDateTime(date, DateTimeConversion.MONTH, locale);
                    String sDay = this.formatDateTime(date, DateTimeConversion.DAY_OF_MONTH_0, locale);
                    char[] result = new char[10];
                    sYear.getChars(0, 4, result, 0);
                    result[4] = 45;
                    sMonth.getChars(0, 2, result, 5);
                    result[7] = 45;
                    sDay.getChars(0, 2, result, 8);
                    return new String(result);
                }
            }
            this.fail(date);
            return null;
        }

        private String formatString(Object arg, Locale locale) {
            if (arg == null) {
                return "null";
            }
            if (arg instanceof Formattable) {
                Formattable f = (Formattable)arg;
                Formatter formatter = new Formatter();
                f.formatTo(formatter, this.getFlags().getValue(), this.getWidth(), this.getPrecision());
                return formatter.toString();
            }
            return this.formatString(arg.toString(), locale);
        }

        private String formatString(String s, Locale locale) {
            if (this.getPrecision() != -1 && this.getPrecision() < s.length()) {
                s = s.substring(0, this.getPrecision());
            }
            if (this.getFlags().contains(Flags.UPPER)) {
                s = s.toUpperCase(locale);
            }
            return this.justify(s);
        }

        private String formatHashCode(Object arg, Locale locale) {
            return this.formatString(Integer.toHexString(arg.hashCode()), locale);
        }

        private String justify(String s) {
            if (this.getWidth() == -1) {
                return s;
            }
            if (s.length() > this.getWidth()) {
                return s;
            }
            int lengthJustification = this.getWidth() - s.length();
            int offsetJustification = this.getFlags().contains(Flags.LEFT_JUSTIFY) ? s.length() : 0;
            int offsetString = this.getFlags().contains(Flags.LEFT_JUSTIFY) ? 0 : lengthJustification;
            int endJustification = offsetJustification + lengthJustification;
            char[] result = new char[this.getWidth()];
            for (int i = offsetJustification; i < endJustification; ++i) {
                result[i] = 32;
            }
            s.getChars(0, s.length(), result, offsetString);
            return new String(result);
        }

        private String formatInteger(long value, Locale locale) {
            String result = null;
            char[] array = null;
            int length = 0;
            switch (this.conversion) {
                case DECIMAL_INTEGER: {
                    String prefix = null;
                    String suffix = null;
                    if (value < 0L) {
                        if (this.getFlags().contains(Flags.PARENTHESE)) {
                            prefix = "(";
                            suffix = ")";
                        } else {
                            prefix = "-";
                        }
                    } else if (this.getFlags().contains(Flags.PLUS)) {
                        prefix = "+";
                    } else if (this.getFlags().contains(Flags.LEADING)) {
                        prefix = " ";
                    }
                    result = this.formatLocalizedNumber(Long.toString(value), value < 0L, prefix, suffix, locale);
                    break;
                }
                case HEXADECIMAL_INTEGER: {
                    result = Long.toHexString(value);
                }
                case OCTAL_INTEGER: {
                    if (result == null) {
                        result = Long.toOctalString(value);
                    }
                    length = (this.getFlags().contains(Flags.ZERO_PAD) ? (result.length() > this.getWidth() ? result.length() : this.getWidth()) : result.length()) + (this.getFlags().contains(Flags.ALTERNATE) ? this.conversion.getAlternate().length() : 0);
                    array = new char[length];
                    int pos = 0;
                    if (this.getFlags().contains(Flags.ALTERNATE)) {
                        String alt = this.conversion.getAlternate();
                        alt.getChars(0, alt.length(), array, pos);
                        pos += alt.length();
                    }
                    if (this.getFlags().contains(Flags.ZERO_PAD) && result.length() < this.getWidth()) {
                        int endPaddingPosition = this.getWidth() - result.length() + pos;
                        for (int i = pos; i < endPaddingPosition; ++i) {
                            array[i] = 48;
                        }
                        pos = endPaddingPosition;
                    }
                    result.getChars(0, result.length(), array, pos);
                    result = new String(array);
                    break;
                }
                default: {
                    this.fail(value);
                }
            }
            if (result == null) {
                this.fail(value);
            }
            return result;
        }

        private String formatFloat(double value, Locale locale) {
            if (Double.isNaN(value)) {
                return this.getFlags().contains(Flags.UPPER) ? "NAN" : "NaN";
            }
            if (Double.isInfinite(value)) {
                return this.getFlags().contains(Flags.UPPER) ? "INFINITY" : "Infinity";
            }
            boolean negative = Double.compare(value, 0.0) < 0;
            FormattedFloatingDecimal ffd = null;
            int precision = this.getPrecision() == -1 ? 6 : this.getPrecision();
            int length = 0;
            switch (this.conversion) {
                case DECIMAL_FLOAT: {
                    ffd = new FormattedFloatingDecimal(value, precision, FormattedFloatingDecimal.Form.DECIMAL_FLOAT);
                    length = ffd.getChars(this.buffer);
                }
                case SCIENTIFIC: {
                    ffd = new FormattedFloatingDecimal(value, precision, FormattedFloatingDecimal.Form.SCIENTIFIC);
                    length = ffd.getChars(this.buffer);
                }
                case GENERAL: {
                    if (precision == 0) {
                        precision = 1;
                    }
                    ffd = new FormattedFloatingDecimal(value, precision, FormattedFloatingDecimal.Form.GENERAL);
                    length = ffd.getChars(this.buffer);
                }
            }
            this.fail(value);
            return null;
        }

        private DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
            if (locale != this.loc || this.dfs == null) {
                this.dfs = new DecimalFormatSymbols(locale);
                this.groupSeparator = this.dfs.getGroupingSeparator();
                this.decimalSeparator = this.dfs.getDecimalSeparator();
                this.zero = this.dfs.getZeroDigit();
                this.loc = locale;
            }
            return this.dfs;
        }

        private DateFormatSymbols getDateFormatSymbols(Locale locale) {
            if (locale != this.loc || this.datefs == null) {
                this.datefs = new DateFormatSymbols(locale);
            }
            return this.datefs;
        }

        private String formatLocalizedNumber(String basicString, boolean negative, Locale locale) {
            return this.formatLocalizedNumber(basicString, negative, null, null, locale);
        }

        private String formatLocalizedNumber(String basicString, boolean negative, String prefix, String suffix, Locale locale) {
            return this.formatLocalizedNumber(basicString, negative, this.getWidth(), this.getFlags(), prefix, suffix, locale);
        }

        private String formatLocalizedNumber(String basicString, boolean negative, int width, Flags myFlags, Locale locale) {
            return this.formatLocalizedNumber(basicString, negative, width, myFlags, null, null, locale);
        }

        private String formatLocalizedNumber(String basicString, boolean negative, int width, Flags myFlags, String prefix, String suffix, Locale locale) {
            int i;
            this.getDecimalFormatSymbols(locale);
            int dotPosition = basicString.length();
            int length = basicString.length();
            if (myFlags.contains(Flags.GROUP)) {
                for (int i2 = 0; i2 < basicString.length(); ++i2) {
                    if (basicString.charAt(i2) != '.') continue;
                    dotPosition = i2;
                    break;
                }
                length += dotPosition / 3;
            }
            int arrayPosition = 0;
            int padLength = 0;
            if (myFlags.contains(Flags.ZERO_PAD) && width > (length += (prefix == null ? 0 : prefix.length()) + (suffix == null ? 0 : suffix.length()))) {
                padLength = width - length;
                length = width;
            }
            char[] array = new char[length];
            if (prefix != null) {
                prefix.getChars(0, prefix.length(), array, 0);
                arrayPosition += prefix.length();
            }
            if (myFlags.contains(Flags.ZERO_PAD)) {
                int endPos = arrayPosition + padLength;
                while (arrayPosition < endPos) {
                    array[arrayPosition] = this.zero;
                    ++arrayPosition;
                }
            }
            boolean decimalPart = false;
            int n = i = negative ? 1 : 0;
            while (i < basicString.length()) {
                char source;
                char dest = source = basicString.charAt(i);
                if (source == '.') {
                    dest = this.decimalSeparator;
                    decimalPart = true;
                } else {
                    dest = (char)(source - 48 + this.zero);
                }
                array[arrayPosition++] = dest;
                if (myFlags.contains(Flags.GROUP) && !decimalPart && i < dotPosition - 1 && (dotPosition - i) % 3 == 1) {
                    array[arrayPosition++] = this.groupSeparator;
                }
                ++i;
            }
            if (suffix != null) {
                suffix.getChars(0, suffix.length(), array, arrayPosition);
            }
            return new String(array, 0, arrayPosition);
        }

        private void fail(Object arg) {
            if (arg == null) {
                throw new IllegalFormatConversionException(this.conversion.getChar(), null);
            }
            throw new IllegalFormatConversionException(this.conversion.getChar(), arg.getClass());
        }
    }

    private static class StringElement
    implements PatternElement {
        private String s = null;

        public StringElement(String s) {
            this.s = s;
        }

        public String format(Object arg, Locale locale) {
            return this.s;
        }

        public int index() {
            return -2;
        }
    }

    private static interface PatternElement {
        public int index();

        public String format(Object var1, Locale var2);
    }

    private static class ArgumentParser {
        static String lineSeparator = System.getProperty("line.separator");
        private String pattern = null;
        private int startArgumentPos = 0;
        private int endArgumentPos = 0;
        private ArgumentNameSpace nameSpace = null;
        private int phase = 0;
        private int pos = 0;
        private int startPhasePos = 0;
        int argument_index = 0;
        String flags = null;
        int width = -1;
        int precision = -1;
        Conversion conversion = null;

        public ArgumentParser(String pattern, int startArgumentPos, ArgumentNameSpace nameSpace) {
            this.pattern = pattern;
            this.startArgumentPos = startArgumentPos;
            this.nameSpace = nameSpace;
        }

        public int getEndArgumentPosition() {
            return this.endArgumentPos;
        }

        private PatternElement parse() {
            if (this.pattern.charAt(this.startArgumentPos) != '%') {
                throw new IllegalStateException("argument pattern must start by %");
            }
            this.pos = this.startArgumentPos + 1;
            this.phase = 0;
            this.startPhasePos = this.pos;
            block7: while (this.pos < this.pattern.length()) {
                if (this.phase == 4) {
                    return this.getPatternElement();
                }
                switch (this.pattern.charAt(this.pos)) {
                    case ' ': 
                    case '#': 
                    case '(': 
                    case '+': 
                    case ',': 
                    case '-': {
                        if (this.phase == 1) {
                            ++this.pos;
                            continue block7;
                        }
                        this.newPhase();
                        continue block7;
                    }
                    case '$': {
                        if (this.phase == 0) {
                            ++this.pos;
                        }
                        this.newPhase();
                        continue block7;
                    }
                    case '.': {
                        if (this.phase == 3 && this.pos == this.startPhasePos) {
                            ++this.pos;
                            continue block7;
                        }
                        this.newPhase();
                        continue block7;
                    }
                    case '<': {
                        if (this.phase == 0) {
                            ++this.pos;
                            continue block7;
                        }
                        this.newPhase();
                        continue block7;
                    }
                    case '%': 
                    case 'n': {
                        if (this.phase != 0 || this.pos != this.startArgumentPos + 1) break;
                        this.endArgumentPos = Math.min(this.pattern.length(), this.pos + 1);
                        if (this.pattern.charAt(this.pos) == '%') {
                            return new StringElement("%");
                        }
                        return new StringElement(lineSeparator);
                    }
                }
                if (Character.isDigit(this.pattern.charAt(this.pos))) {
                    if (this.phase == 0 || this.phase == 2 || this.phase == 3) {
                        ++this.pos;
                        continue;
                    }
                    if (this.phase == 1 && this.pattern.charAt(this.pos) == '0') {
                        ++this.pos;
                        continue;
                    }
                }
                this.newPhase();
            }
            throw new IllegalStateException("unable to fin conversion properties on last argument");
        }

        private void newPhase() {
            int endPhasePos = this.pos;
            boolean consumed = false;
            switch (this.phase) {
                case 0: {
                    if (endPhasePos > this.startPhasePos && this.pattern.charAt(endPhasePos - 1) == '$') {
                        if (this.nameSpace != null && this.nameSpace instanceof IndexableArgumentNameSpace) {
                            throw new IllegalStateException("can't specify an index ordering statement with an IndexArgumentNameSpace");
                        }
                        String s = this.pattern.substring(this.startPhasePos, endPhasePos - 1);
                        this.argument_index = s.equals("<") ? -1 : Integer.parseInt(s);
                        consumed = true;
                        break;
                    }
                    this.argument_index = 0;
                    break;
                }
                case 1: {
                    char firstChar;
                    if (endPhasePos <= this.startPhasePos || (firstChar = this.pattern.charAt(this.startPhasePos)) != '-' && firstChar != '#' && firstChar != '+' && firstChar != ' ' && firstChar != '0' && firstChar != ',' && firstChar != '(') break;
                    this.flags = this.pattern.substring(this.startPhasePos, endPhasePos);
                    consumed = true;
                    break;
                }
                case 2: {
                    char firstChar;
                    if (endPhasePos <= this.startPhasePos || !Character.isDigit(firstChar = this.pattern.charAt(this.startPhasePos))) break;
                    String s = this.pattern.substring(this.startPhasePos, endPhasePos);
                    this.width = Integer.parseInt(s);
                    consumed = true;
                    break;
                }
                case 3: {
                    char firstChar;
                    if (endPhasePos <= this.startPhasePos || (firstChar = this.pattern.charAt(this.startPhasePos)) != '.') break;
                    String s = this.pattern.substring(this.startPhasePos + 1, endPhasePos);
                    this.precision = Integer.parseInt(s);
                    consumed = true;
                }
            }
            ++this.phase;
            if (consumed) {
                this.startPhasePos = endPhasePos;
            } else {
                this.pos = this.startPhasePos;
            }
        }

        private PatternElement getPatternElement() {
            int length = 1;
            DateTimeConversion dtc = null;
            String matchSymbol = null;
            if (this.nameSpace != null) {
                for (String symbol : this.nameSpace.symbols()) {
                    if (!this.pattern.startsWith(symbol, this.startPhasePos) || matchSymbol != null && symbol.length() <= matchSymbol.length()) continue;
                    matchSymbol = symbol;
                    length = symbol.length();
                }
                if (matchSymbol != null) {
                    this.nameSpace.use(matchSymbol);
                    if (this.nameSpace instanceof IndexableArgumentNameSpace) {
                        this.argument_index = ((IndexableArgumentNameSpace)this.nameSpace).index(matchSymbol) + 1;
                    }
                    this.conversion = this.nameSpace.getConversion(matchSymbol);
                }
                if (this.conversion == null) {
                    throw new IllegalArgumentException("unknown [" + this.pattern.substring(this.startPhasePos) + "] symbol's namespace");
                }
            } else {
                this.conversion = Conversion.parse(this.pattern.charAt(this.startPhasePos));
                if (this.conversion == null) {
                    throw new IllegalArgumentException("unknown [" + this.pattern.charAt(this.startPhasePos) + "] conversion's flag");
                }
            }
            switch (this.conversion) {
                case DATE_TIME: 
                case DATE_TIME_UPPER: {
                    char charDTC;
                    if (this.nameSpace != null) {
                        String datetimeSeparator = this.nameSpace.getDateSeparator(matchSymbol);
                        if (datetimeSeparator != null && datetimeSeparator.length() > 0 && !this.pattern.startsWith(datetimeSeparator, this.startPhasePos + length)) {
                            throw new IllegalArgumentException("date-time suffix from '" + matchSymbol + "' must be separate with '" + datetimeSeparator + "'");
                        }
                        length += datetimeSeparator == null ? 0 : datetimeSeparator.length();
                    }
                    if ((dtc = DateTimeConversion.parse(charDTC = this.pattern.charAt(this.startPhasePos + length++))) != null) break;
                    throw new IllegalArgumentException("unknown [" + charDTC + "] Date-Time suffix");
                }
            }
            this.endArgumentPos = Math.min(this.pattern.length(), this.startPhasePos + length);
            ArgumentDetails details = new ArgumentDetails(Flags.parse(this.flags, this.conversion), this.width, this.precision, dtc);
            if (this.nameSpace instanceof DetailedArgumentNameSpace) {
                details = ((DetailedArgumentNameSpace)this.nameSpace).getDetails(details, matchSymbol);
            }
            ArgumentElement result = new ArgumentElement(this.argument_index, this.conversion, details);
            if (this.nameSpace instanceof AttributeArgumentNameSpace) {
                result.setNameSpace((AttributeArgumentNameSpace)this.nameSpace, matchSymbol);
            }
            return result;
        }
    }

    public static class ArgumentDetails {
        private Flags flags = Flags.NONE;
        private int width = -1;
        private int precision = -1;
        private DateTimeConversion timeConversion = null;

        private ArgumentDetails(Flags flags, int width, int precision, DateTimeConversion datetimeConversion) {
            this.setFlags(flags);
            this.setWidth(width);
            this.setPrecision(precision);
            this.setDateTimeConversion(datetimeConversion);
        }

        public Flags getFlags() {
            return this.flags;
        }

        public void setFlags(Flags flags) {
            this.flags = flags;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public DateTimeConversion getDateTimeConversion() {
            return this.timeConversion;
        }

        public void setDateTimeConversion(DateTimeConversion dateTimeConversion) {
            this.timeConversion = dateTimeConversion;
        }
    }

    public static final class Pattern {
        private String pattern = null;
        private List<PatternElement> elements = null;
        private ArgumentNameSpace nameSpace = null;

        private Pattern(String pattern, ArgumentNameSpace nameSpace) {
            this.pattern = pattern;
            this.nameSpace = nameSpace;
        }

        public String getPattern() {
            return this.pattern;
        }

        public ArgumentNameSpace getNameSpace() {
            return this.nameSpace;
        }

        private PatternElement getElements(int index) {
            if (this.elements == null) {
                return null;
            }
            return this.elements.get(index);
        }

        private int size() {
            if (this.elements == null) {
                return 0;
            }
            return this.elements.size();
        }

        private void addElement(PatternElement element) {
            if (this.elements == null) {
                this.elements = new ArrayList<PatternElement>(10);
            }
            this.elements.add(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateTimeConversion {
        HOUR_OF_DAY_0('H'),
        HOUR_0('I'),
        HOUR_OF_DAY('k'),
        HOUR('l'),
        MINUTE('M'),
        NANOSECOND('N'),
        MILLISECOND('L'),
        MILLISECOND_SINCE_EPOCH('Q'),
        AM_PM('p'),
        SECONDS_SINCE_EPOCH('s'),
        SECOND('S'),
        TIME('T'),
        ZONE_NUMERIC('z'),
        ZONE('Z'),
        NAME_OF_DAY_ABBREV('a'),
        NAME_OF_DAY('A'),
        NAME_OF_MONTH_ABBREV('b'),
        NAME_OF_MONTH('B'),
        CENTURY('C'),
        DAY_OF_MONTH_0('d'),
        DAY_OF_MONTH('e'),
        NAME_OF_MONTH_ABBREV_X('h'),
        DAY_OF_YEAR('j'),
        MONTH('m'),
        YEAR_2('y'),
        YEAR_4('Y'),
        TIME_12_HOUR('r'),
        TIME_24_HOUR('R'),
        DATE_TIME('c'),
        DATE('D'),
        ISO_STANDARD_DATE('F');

        private char car;

        private DateTimeConversion(char car) {
            this.car = car;
        }

        public char getChar() {
            return this.car;
        }

        public static DateTimeConversion parse(char car) {
            DateTimeConversion[] all;
            for (DateTimeConversion c : all = DateTimeConversion.values()) {
                if (c.getChar() != car) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Conversion {
        DECIMAL_INTEGER('d', false, null, null),
        OCTAL_INTEGER('o', false, null, "0"),
        HEXADECIMAL_INTEGER('x', false, null, "0x"),
        HEXADECIMAL_INTEGER_UPPER('X', true, HEXADECIMAL_INTEGER, "0X"),
        SCIENTIFIC('e', false, null, null),
        SCIENTIFIC_UPPER('E', true, SCIENTIFIC, null),
        GENERAL('g', false, null, null),
        GENERAL_UPPER('G', true, GENERAL, null),
        DECIMAL_FLOAT('f', false, null, null),
        HEXADECIMAL_FLOAT('a', false, null, null),
        HEXADECIMAL_FLOAT_UPPER('A', true, HEXADECIMAL_FLOAT, null),
        CHARACTER('c', false, null, null),
        CHARACTER_UPPER('C', true, CHARACTER, null),
        DATE_TIME('t', false, null, null),
        DATE_TIME_UPPER('T', true, DATE_TIME, null),
        BOOLEAN('b', false, null, null),
        BOOLEAN_UPPER('B', true, BOOLEAN, null),
        STRING('s', false, null, null),
        STRING_UPPER('S', true, STRING, null),
        HASHCODE('h', false, null, null),
        HASHCODE_UPPER('H', true, HASHCODE, null);

        private char car;
        private boolean upper = false;
        private Conversion effective = null;
        private String alternate = null;

        private Conversion(char car, boolean upper, Conversion conversion, String alternate) {
            this.car = car;
            this.upper = upper;
            this.effective = conversion == null ? this : conversion;
            this.alternate = alternate;
        }

        public char getChar() {
            return this.car;
        }

        public boolean isUpper() {
            return this.upper;
        }

        public Conversion getEffectiveConversion() {
            return this.effective;
        }

        public String getAlternate() {
            return this.alternate;
        }

        public static Conversion parse(char car) {
            Conversion[] all;
            for (Conversion c : all = Conversion.values()) {
                if (c.getChar() != car) continue;
                return c;
            }
            return null;
        }
    }

    public static interface DetailedArgumentNameSpace
    extends ArgumentNameSpace {
        public ArgumentDetails getDetails(ArgumentDetails var1, String var2);
    }

    public static interface AttributeArgumentNameSpace
    extends ArgumentNameSpace {
        public Object getAtttribute(Object var1, String var2, Locale var3);
    }

    public static interface IndexableArgumentNameSpace
    extends ArgumentNameSpace {
        public int index(String var1);
    }

    public static interface ArgumentNameSpace {
        public String[] symbols();

        public Conversion getConversion(String var1);

        public String getDateSeparator(String var1);

        public void use(String var1);
    }
}

