/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.concurrent.TimeUnit;

public class TimeFormat
extends Format {
    private static final NumberFormat DAY_FORMAT = new DecimalFormat("#,##0");
    private static final NumberFormat HOUR_FORMAT = new DecimalFormat("00");
    private static final NumberFormat MINUTE_FORMAT = new DecimalFormat("00");
    private static final NumberFormat SECOND_FORMAT = new DecimalFormat("00");
    private static final NumberFormat MILLISECOND_FORMAT = new DecimalFormat("###,000");
    private static final NumberFormat MICROSECOND_FORMAT = new DecimalFormat("###,000");
    private static final NumberFormat NANOSECOND_FORMAT = new DecimalFormat("###,000");
    private TimeUnit unit = null;

    public TimeFormat() {
        this(TimeUnit.MILLISECONDS);
    }

    public TimeFormat(TimeUnit unit) {
        this.unit = unit;
    }

    public String format(long delay, TimeUnit unit) {
        return this.format(this.getTimeUnit().convert(delay, unit));
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        long nanoTime;
        long time = ((Number)obj).longValue();
        long nanos = nanoTime = TimeUnit.NANOSECONDS.convert(time, this.getTimeUnit());
        long micros = nanoTime / 1000L;
        nanos -= micros * 1000L;
        long millis = micros / 1000L;
        micros -= millis * 1000L;
        long secs = millis / 1000L;
        millis -= secs * 1000L;
        long mins = secs / 60L;
        secs -= mins * 60L;
        long hours = mins / 60L;
        mins -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        boolean forced = false;
        if (days > 0L) {
            DAY_FORMAT.format(days, toAppendTo, pos);
            toAppendTo.append("d");
            boolean bl = forced = hours + mins + secs + millis + micros + nanos > 0L;
        }
        if (forced || hours > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            HOUR_FORMAT.format(hours, toAppendTo, pos);
            toAppendTo.append("h");
            boolean bl = forced = mins + secs + millis + micros + nanos > 0L;
        }
        if (forced || mins > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            MINUTE_FORMAT.format(mins, toAppendTo, pos);
            toAppendTo.append("m");
            boolean bl = forced = secs + millis + micros + nanos > 0L;
        }
        if (forced || secs > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            SECOND_FORMAT.format(secs, toAppendTo, pos);
            toAppendTo.append("s");
            boolean bl = forced = millis + micros + nanos > 0L;
        }
        if (forced || millis > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            MILLISECOND_FORMAT.format(millis, toAppendTo, pos);
            toAppendTo.append("ms");
            boolean bl = forced = micros + nanos > 0L;
        }
        if (forced || micros > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            MICROSECOND_FORMAT.format(micros, toAppendTo, pos);
            toAppendTo.append("\u03bcs");
            boolean bl = forced = nanos > 0L;
        }
        if (forced || nanos > 0L) {
            if (forced) {
                toAppendTo.append(' ');
            }
            NANOSECOND_FORMAT.format(nanos, toAppendTo, pos);
            toAppendTo.append("ns");
        }
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        if (source == null) {
            return 0L;
        }
        long resultInNanos = 0L;
        int valueStartIndex = -1;
        int valueEndIndex = -1;
        TimeUnit valueUnit = null;
        for (int i = 0; i < source.length(); ++i) {
            char car = source.charAt(i);
            if (Character.isWhitespace(car)) continue;
            if (Character.isDigit(car)) {
                if (valueStartIndex != -1) continue;
                valueStartIndex = i;
                continue;
            }
            if (valueStartIndex != -1) {
                valueEndIndex = i + 1;
            }
            if (valueEndIndex != -1) {
                int nextCar;
                int n = nextCar = i + 1 < source.length() ? (int)source.charAt(i + 1) : 32;
                if (car == 'd') {
                    valueUnit = TimeUnit.DAYS;
                } else if (car == 'h') {
                    valueUnit = TimeUnit.HOURS;
                } else if (car == 'm' && nextCar == 115) {
                    valueUnit = TimeUnit.MILLISECONDS;
                } else if (car == 'm') {
                    valueUnit = TimeUnit.MINUTES;
                } else if (car == 's') {
                    valueUnit = TimeUnit.SECONDS;
                } else if (car == '\u03bc' && nextCar == 115) {
                    valueUnit = TimeUnit.MICROSECONDS;
                } else if (car == 'n' && nextCar == 115) {
                    valueUnit = TimeUnit.NANOSECONDS;
                } else {
                    pos.setIndex(0);
                    pos.setErrorIndex(i);
                    return null;
                }
                Number value = null;
                try {
                    value = (Number)NANOSECOND_FORMAT.parseObject(source.substring(valueStartIndex, valueEndIndex));
                }
                catch (ParseException pe) {
                    pos.setIndex(0);
                    pos.setErrorIndex(pe.getErrorOffset() + valueStartIndex);
                    return null;
                }
                resultInNanos += TimeUnit.NANOSECONDS.convert(value.longValue(), valueUnit);
                if (valueUnit == TimeUnit.MILLISECONDS || valueUnit == TimeUnit.MICROSECONDS) {
                    ++i;
                }
                valueStartIndex = -1;
                valueEndIndex = -1;
                valueUnit = null;
                continue;
            }
            pos.setIndex(0);
            pos.setErrorIndex(i);
            return null;
        }
        pos.setIndex(source.length());
        return this.getTimeUnit().convert(resultInNanos, TimeUnit.NANOSECONDS);
    }

    public TimeUnit getTimeUnit() {
        return this.unit;
    }
}

