/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public abstract class ImageUtilities {
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID = 0;

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageUtilities.getScaledImage(image, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitFor(Image image) {
        if (image == null) {
            return true;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = ++mediaTrackerID;
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            try {
                if (tracker.statusID(id, false) != 8) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                tracker.removeImage(image, id);
            }
        }
    }

    public static BufferedImage getFittedImage(Image image, int maxWidth, int maxHeight) {
        if (image == null) {
            return null;
        }
        ImageUtilities.waitFor(image);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        float ratio = (float)width / (float)height;
        int widthScaled = (int)((float)maxHeight * ratio);
        int heighScaled = (int)((float)maxWidth / ratio);
        if (widthScaled <= maxWidth) {
            return ImageUtilities.getScaledImage(image, -1, maxHeight);
        }
        return ImageUtilities.getScaledImage(image, maxWidth, -1);
    }

    public static BufferedImage getScaledImage(Image image, int width, int height) {
        boolean reducingByIteration;
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("size can't be set to 0 for resampling");
        }
        if (image == null) {
            throw new IllegalArgumentException("image can't be null");
        }
        ImageUtilities.waitFor(image);
        float originalRatio = (float)image.getWidth(null) / (float)image.getHeight(null);
        boolean aspectRatioRespected = width < 0 || height < 0;
        boolean sizePreserved = width < 0 && height < 0;
        int newWidth = width;
        int newHeight = height;
        if (newWidth < 0 && newHeight < 0) {
            newWidth = image.getWidth(null);
            newHeight = image.getHeight(null);
        } else if (newWidth < 0) {
            newWidth = (int)((float)newHeight * originalRatio);
        } else if (newHeight < 0) {
            newHeight = (int)((float)newWidth / originalRatio);
        } else {
            aspectRatioRespected = (float)newWidth / (float)newHeight == originalRatio;
        }
        sizePreserved = sizePreserved || newWidth == image.getWidth(null) && newHeight == image.getWidth(null);
        int opacity = 1;
        int type = 1;
        if (image instanceof BufferedImage) {
            opacity = ((BufferedImage)image).getTransparency();
            type = ((BufferedImage)image).getType();
        }
        boolean bl = reducingByIteration = aspectRatioRespected && !sizePreserved && newWidth <= image.getWidth(null) && newHeight <= image.getHeight(null);
        if (reducingByIteration) {
            float ratio;
            Image source = image;
            boolean isWidth = image.getWidth(null) > image.getHeight(null);
            int currentSize = isWidth ? image.getWidth(null) : image.getHeight(null);
            int refSize = isWidth ? newWidth : newHeight;
            float f = ratio = isWidth ? (float)newHeight / (float)newWidth : (float)newWidth / (float)newHeight;
            while (currentSize > refSize) {
                int myWidth = 0;
                int myHeight = 0;
                if ((currentSize /= 2) < refSize) {
                    myWidth = newWidth;
                    myHeight = newHeight;
                } else if (isWidth) {
                    myWidth = currentSize;
                    myHeight = Math.round((float)myWidth * ratio);
                    if (myHeight < newHeight) {
                        myHeight = newHeight;
                    }
                } else {
                    myHeight = currentSize;
                    myWidth = Math.round((float)myHeight * ratio);
                    if (myWidth < newWidth) {
                        myWidth = newWidth;
                    }
                }
                source = ImageUtilities.getScaledImageImpl(source, myWidth, myHeight, type, opacity);
                currentSize = isWidth ? myWidth : myHeight;
            }
            return (BufferedImage)source;
        }
        return ImageUtilities.getScaledImageImpl(image, newWidth, newHeight, type, opacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage getScaledImageImpl(Image source, int width, int height, int type, int opacity) {
        BufferedImage scaledImage = GraphicsEnvironment.isHeadless() ? new BufferedImage(width, height, type) : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(width, height, opacity);
        Graphics2D graphics2D = scaledImage.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(source, 0, 0, width, height, null);
        }
        finally {
            graphics2D.dispose();
        }
        return scaledImage;
    }
}

