/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.commons;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Objects {
    public static String toNativeString(Object o) {
        if (o == null) {
            return String.valueOf(o);
        }
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    public static int compare(Comparable a, Comparable b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return b.compareTo(a) * -1;
        }
        return a.compareTo(b);
    }

    public static <T extends Comparable> Comparator<T> createNaturalComparator(Class<T> type) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare(o1, o1);
            }
        };
    }

    public static <T> Comparator<T> createSafeComparator(final Comparator<T> unsafe, final int nullOrder) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return nullOrder;
                }
                if (o2 == null) {
                    return nullOrder * -1;
                }
                return unsafe.compare(o1, o2);
            }
        };
    }

    public static boolean areEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }
        return false;
    }
}

