/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.commons;

public abstract class Condition {
    public static final Condition TRUE = new Condition(){

        public boolean isTrue() {
            return true;
        }

        public String toString() {
            return "true";
        }
    };
    public static final Condition FALSE = new Condition(){

        public boolean isTrue() {
            return false;
        }

        public String toString() {
            return "false";
        }
    };

    public abstract boolean isTrue();

    public final Condition or(final Condition other) {
        return new Condition(){

            public boolean isTrue() {
                return Condition.this.isTrue() || other.isTrue();
            }

            public String toString() {
                return "(" + Condition.this.toString() + " || " + other.toString() + ")";
            }
        };
    }

    public final Condition xor(final Condition other) {
        return new Condition(){

            public boolean isTrue() {
                boolean a = Condition.this.isTrue();
                boolean b = other.isTrue();
                return a && !b || b && !a;
            }

            public String toString() {
                return "(" + Condition.this.toString() + " || " + other.toString() + ")";
            }
        };
    }

    public final Condition and(final Condition other) {
        return new Condition(){

            public boolean isTrue() {
                return Condition.this.isTrue() && other.isTrue();
            }

            public String toString() {
                return "(" + Condition.this.toString() + " && " + other.toString() + ")";
            }
        };
    }

    public final Condition not() {
        return new Condition(){

            public boolean isTrue() {
                return !Condition.this.isTrue();
            }

            public String toString() {
                return "!(" + Condition.this.toString() + ")";
            }
        };
    }
}

