/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.commons;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    public static <T> T[] random(T[] array) {
        int i;
        Object[] randArray = new RandomizedItem[array.length];
        for (i = 0; i < array.length; ++i) {
            randArray[i] = new RandomizedItem(array[i]);
        }
        java.util.Arrays.sort(randArray);
        for (i = 0; i < array.length; ++i) {
            array[i] = ((RandomizedItem)randArray[i]).getItem();
        }
        return array;
    }

    public static <E> E[] concat(E[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        int length = 0;
        int count = 0;
        E[] firstNotEmpty = null;
        E[] firstNotNull = null;
        for (E[] array : arrays) {
            if (array == null) continue;
            if (firstNotNull == null) {
                firstNotNull = array;
            }
            if (array.length <= 0) continue;
            if (firstNotEmpty == null) {
                firstNotEmpty = array;
            }
            ++count;
            length += array.length;
        }
        if (count == 0) {
            if (firstNotNull != null) {
                return firstNotNull;
            }
            return null;
        }
        if (count == 1) {
            return firstNotEmpty;
        }
        Object[] result = (Object[])Array.newInstance(firstNotNull.getClass().getComponentType(), length);
        int index = 0;
        for (E[] array : arrays) {
            if (array == null || array.length <= 0) continue;
            System.arraycopy(array, 0, result, index, array.length);
            index += array.length;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomizedItem
    implements Comparable<RandomizedItem> {
        private Object item = null;
        private double randomizer = Math.random();

        public RandomizedItem(Object o) {
            this.item = o;
        }

        public Object getItem() {
            return this.item;
        }

        public double getRandomizer() {
            return this.randomizer;
        }

        @Override
        public int compareTo(RandomizedItem o) {
            if (this == o) {
                return 0;
            }
            if (o == null) {
                return -1;
            }
            if (this.getRandomizer() < o.getRandomizer()) {
                return -1;
            }
            if (this.getRandomizer() > o.getRandomizer()) {
                return 1;
            }
            return 0;
        }
    }
}

