/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeIterator<E>
implements Iterator<E> {
    private Iterator<E>[] iterators = null;
    private int index = -1;
    private Iterator<E> currentIterator = null;

    public MergeIterator(Iterator<E> ... iterators) {
        this.iterators = iterators;
    }

    public MergeIterator(Iterable<E> ... iterables) {
        if (iterables == null) {
            return;
        }
        this.iterators = new Iterator[iterables.length];
        for (int i = 0; i < iterables.length; ++i) {
            if (iterables[i] == null) continue;
            this.iterators[i] = iterables[i].iterator();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator != null) {
            if (this.currentIterator.hasNext()) {
                return true;
            }
            this.currentIterator = null;
        }
        if (this.iterators == null) {
            return false;
        }
        ++this.index;
        if (this.index >= this.iterators.length) {
            return false;
        }
        this.currentIterator = this.iterators[this.index];
        return this.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        if (this.currentIterator == null) {
            throw new UnsupportedOperationException();
        }
        this.currentIterator.remove();
    }
}

