/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.collection;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBuffer<E>
extends AbstractCollection<E>
implements Queue<E> {
    private Object[] array = null;
    private int offset = 0;
    private int count = 0;
    private int modCount = 0;

    public CyclicBuffer() {
        this(10);
    }

    public CyclicBuffer(int capacity) {
        this.setCapacity(capacity);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        if (a.length == 0) {
            return a;
        }
        return this.toArrayImpl(a);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayImpl(a);
    }

    @Override
    public boolean add(E o) {
        this.array[this.offset++] = o;
        if (this.count < this.getCapacity()) {
            ++this.count;
        }
        if (this.offset >= this.getCapacity()) {
            this.offset = 0;
        }
        ++this.modCount;
        return true;
    }

    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("index " + index + " out of bound");
        }
        return (E)this.array[this.logicalIndexToPhysicalIndex(index)];
    }

    public E getLast() {
        int i;
        if (this.isEmpty()) {
            return null;
        }
        if ((i = this.offset--) < 0) {
            i = this.getCapacity() - 1;
        }
        return (E)this.array[i];
    }

    public E getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return (E)this.array[this.getFirstElementPhysicalIndex()];
    }

    public void set(int index, E object) {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException("index " + index + " out of bound");
        }
        this.array[this.logicalIndexToPhysicalIndex((int)index)] = object;
    }

    private int getFirstElementPhysicalIndex() {
        if (this.size() < this.getCapacity()) {
            return 0;
        }
        int start = this.offset + 1;
        return start == this.getCapacity() ? 0 : start;
    }

    private int logicalIndexToPhysicalIndex(int logicalIndex) {
        return (this.getFirstElementPhysicalIndex() + logicalIndex) % this.getCapacity();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove(Object) is unsupported by CyclicBuffer, use peek() or remove() for removing last entry");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll(Collection) is unsupported by CyclicBuffer");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll(Collection) is unsupported by CyclicBuffer");
    }

    @Override
    public void clear() {
        this.count = 0;
        this.offset = 0;
        Arrays.fill(this.array, 0, this.array.length, null);
        ++this.modCount;
    }

    @Override
    public synchronized boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public synchronized E poll() {
        if (this.count == 0) {
            return null;
        }
        --this.offset;
        if (this.offset < 0) {
            this.offset = this.getCapacity() - 1;
        }
        ++this.modCount;
        return (E)this.array[this.offset];
    }

    @Override
    public synchronized E remove() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.poll();
    }

    @Override
    public synchronized E peek() {
        if (this.count == 0) {
            return null;
        }
        int index = this.offset - 1;
        if (index < 0) {
            index = this.getCapacity() - 1;
        }
        ++this.modCount;
        return (E)this.array[index];
    }

    @Override
    public synchronized E element() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.peek();
    }

    public void setCapacity(int newCapacity) {
        if (newCapacity <= 0) {
            throw new IllegalArgumentException("capacity can't be less than 1");
        }
        this.array = this.toArrayImpl(new Object[newCapacity]);
        this.offset = this.count = this.size() > newCapacity ? newCapacity : this.size();
        if (this.offset >= this.size()) {
            this.offset = 0;
        }
        ++this.modCount;
    }

    public int getCapacity() {
        return this.array == null ? 0 : this.array.length;
    }

    private Object[] toArrayImpl(Object[] result) {
        int newSize = result.length;
        if (newSize <= 0) {
            throw new IllegalArgumentException("size can't be less than 1");
        }
        if (this.array != null) {
            int newCount;
            int copied = newCount = this.count > newSize ? newSize : this.count;
            int skipped = this.count - copied;
            boolean traited = false;
            int newOffset = 0;
            if (this.count > this.offset) {
                int skippable = this.getCapacity() - this.offset;
                if (skipped < skippable) {
                    int length = skippable - skipped;
                    System.arraycopy(this.array, this.offset + skipped, result, newOffset, length);
                    skipped = 0;
                    copied -= length;
                    newOffset += length;
                } else {
                    skipped -= skippable;
                }
            }
            if (copied > 0) {
                System.arraycopy(this.array, 0 + skipped, result, newOffset, copied);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        int shift;
        int current;
        int expectedModCount;

        private Itr() {
            this.shift = CyclicBuffer.this.size() > CyclicBuffer.this.offset ? CyclicBuffer.this.offset : 0;
            this.current = 0;
            this.expectedModCount = CyclicBuffer.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.current < CyclicBuffer.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int index = this.current + this.shift;
                if (index >= CyclicBuffer.this.getCapacity()) {
                    index -= CyclicBuffer.this.getCapacity();
                }
                Object result = CyclicBuffer.this.array[index];
                ++this.current;
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.checkForComodification();
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkForComodification() {
            if (CyclicBuffer.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

