/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.collection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.divxdede.commons.Disposable;
import org.divxdede.text.formatter.SimpleFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<K, V>
implements Disposable,
Iterable<V> {
    private final CacheHelper<K, V> helper;
    private final RemovalEntryPolicy policy;

    public Cache(int maximumSize, RemovalEntryPolicy policy) {
        this.policy = policy;
        switch (this.policy) {
            case LeastFrequentlyUsed: {
                this.helper = new FrequencyMap(maximumSize);
                break;
            }
            case LeastRecentlyUsed: {
                this.helper = new FixedMap(maximumSize, true);
                break;
            }
            case OldestInsertion: {
                this.helper = new FixedMap(maximumSize, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("policy can't be null");
            }
        }
    }

    public RemovalEntryPolicy getRemovalEntryPolicy() {
        return this.policy;
    }

    public synchronized V put(K key, V value) {
        return this.helper.put(key, value);
    }

    public synchronized V get(K key) {
        return this.helper.get(key);
    }

    public synchronized boolean containsKey(K key) {
        return this.helper.containsKey(key);
    }

    @Override
    public synchronized Iterator<V> iterator() {
        return this.helper.iterator();
    }

    public synchronized Iterator<K> iteratorKeys() {
        return this.helper.iteratorKeys();
    }

    public int getMaximumSize() {
        return this.helper.getMaximumSize();
    }

    @Override
    public synchronized void dispose() {
        this.helper.dispose();
    }

    public synchronized int getSize() {
        return this.helper.getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyBullet<K, V>
    implements Iterable<FrequencyEntry<K, V>> {
        int frequency;
        FrequencyBullet<K, V> previousBullet = null;
        FrequencyBullet<K, V> nextBullet = null;
        FrequencyEntry<K, V> firstEntry = null;

        public FrequencyBullet(int frequency) {
            this.frequency = frequency;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public void insertBefore(FrequencyBullet<K, V> postBullet) {
            this.previousBullet = postBullet.previousBullet;
            this.nextBullet = postBullet;
            if (postBullet.previousBullet != null) {
                postBullet.previousBullet.nextBullet = this;
            }
            postBullet.previousBullet = this;
        }

        public void insertAfter(FrequencyBullet<K, V> precedingBullet) {
            this.previousBullet = precedingBullet;
            this.nextBullet = precedingBullet.nextBullet;
            if (precedingBullet.nextBullet != null) {
                precedingBullet.nextBullet.previousBullet = this;
            }
            precedingBullet.nextBullet = this;
        }

        public void remove() {
            if (this.firstEntry != null) {
                throw new IllegalStateException("can't remove a non-empty bullet from the bullet's chain");
            }
            if (this.previousBullet != null) {
                this.previousBullet.nextBullet = this.nextBullet;
            }
            if (this.nextBullet != null) {
                this.nextBullet.previousBullet = this.previousBullet;
            }
            this.previousBullet = null;
            this.nextBullet = null;
        }

        public void add(FrequencyEntry<K, V> entry) {
            if (entry.bullet != null) {
                throw new IllegalStateException("Can't add an already linked-entry to a bullet");
            }
            entry.bullet = this;
            entry.previous = null;
            entry.next = this.firstEntry;
            if (this.firstEntry != null) {
                this.firstEntry.previous = entry;
            }
            this.firstEntry = entry;
        }

        private FrequencyBullet<K, V> remove(FrequencyEntry<K, V> entry) {
            if (entry.bullet != this) {
                throw new IllegalStateException("Can't remove a bullet from it's non-owner bullet");
            }
            FrequencyBullet<K, V> result = this;
            FrequencyEntry oldPreviousEntry = entry.previous;
            FrequencyEntry oldNextEntry = entry.next;
            if (this.firstEntry == entry) {
                this.firstEntry = entry.next;
            }
            if (oldPreviousEntry != null) {
                oldPreviousEntry.next = oldNextEntry;
            }
            if (oldNextEntry != null) {
                oldNextEntry.previous = oldPreviousEntry;
            }
            if (this.firstEntry == null) {
                result = this.nextBullet;
                this.remove();
            }
            entry.previous = null;
            entry.next = null;
            entry.bullet = null;
            return result;
        }

        @Override
        public Iterator<FrequencyEntry<K, V>> iterator() {
            return new Iterator<FrequencyEntry<K, V>>(){
                FrequencyBullet<K, V> currentBullet;
                FrequencyEntry<K, V> currentEntry;
                {
                    this.currentBullet = FrequencyBullet.this;
                    this.currentEntry = this.currentBullet.firstEntry;
                }

                @Override
                public boolean hasNext() {
                    if (this.currentEntry != null) {
                        return true;
                    }
                    this.currentBullet = this.currentBullet.nextBullet;
                    if (this.currentBullet == null) {
                        return false;
                    }
                    this.currentEntry = this.currentBullet.firstEntry;
                    return this.currentEntry != null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FrequencyEntry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        FrequencyEntry frequencyEntry = this.currentEntry;
                        return frequencyEntry;
                    }
                    finally {
                        this.currentEntry = this.currentEntry.next;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            return SimpleFormatter.format("Bullet[@%%,frequency=%%]", Integer.toHexString(System.identityHashCode(this)), this.getFrequency());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyEntry<K, V> {
        private K key = null;
        private V value = null;
        FrequencyBullet<K, V> bullet = null;
        FrequencyEntry<K, V> previous = null;
        FrequencyEntry<K, V> next = null;

        public FrequencyEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public int getFrequency() {
            return this.bullet.getFrequency();
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public FrequencyBullet<K, V> recordAccess() {
            FrequencyBullet eldest = null;
            int newFrequency = this.bullet.getFrequency() + 1;
            if (this.bullet.nextBullet != null && this.bullet.nextBullet.getFrequency() == newFrequency) {
                FrequencyBullet newBullet = this.bullet.nextBullet;
                eldest = ((FrequencyBullet)this.bullet).remove(this);
                if (eldest != null && eldest.previousBullet != null) {
                    eldest = null;
                }
                newBullet.add(this);
            } else if (this.bullet.firstEntry == this && this.next == null) {
                ++this.bullet.frequency;
            } else {
                FrequencyBullet<K, V> newBullet = new FrequencyBullet<K, V>(newFrequency);
                newBullet.insertAfter(this.bullet);
                eldest = ((FrequencyBullet)this.bullet).remove(this);
                if (eldest != null && eldest.previousBullet != null) {
                    eldest = null;
                }
                newBullet.add(this);
            }
            return eldest;
        }

        public String toString() {
            return SimpleFormatter.format("Entry[@%%,key=%%,value=%%,bullet=%%]", Integer.toHexString(System.identityHashCode(this)), this.getKey(), this.getValue(), this.bullet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyMap<K, V>
    implements CacheHelper<K, V> {
        private FrequencyBullet<K, V> firstBullet = null;
        private int maximumSize = 0;
        private HashMap<K, FrequencyEntry<K, V>> map = null;

        public FrequencyMap(int maximumSize) {
            this.maximumSize = maximumSize;
            this.map = new HashMap();
        }

        @Override
        public int getMaximumSize() {
            return this.maximumSize;
        }

        @Override
        public V put(K key, V value) {
            FrequencyEntry<K, V> entry = this.map.get(key);
            if (entry != null) {
                V oldValue = entry.getValue();
                entry.setValue(value);
                this.recordAccess(entry);
                return oldValue;
            }
            if (this.getSize() == this.getMaximumSize()) {
                this.removeEldestEntry();
            }
            entry = new FrequencyEntry<K, V>(key, value);
            if (this.firstBullet == null || this.firstBullet.getFrequency() > 1) {
                FrequencyBullet<K, V> newBullet = new FrequencyBullet<K, V>(1);
                if (this.firstBullet != null) {
                    newBullet.insertBefore(this.firstBullet);
                }
                newBullet.add(entry);
                this.firstBullet = newBullet;
            } else {
                this.firstBullet.add(entry);
            }
            this.map.put(key, entry);
            return null;
        }

        @Override
        public Iterator<V> iterator() {
            if (this.firstBullet == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return new Iterator<V>(){
                Iterator<FrequencyEntry<K, V>> i;
                Iterator<K> j;
                {
                    this.i = FrequencyMap.this.firstBullet.iterator();
                    this.j = FrequencyMap.this.map.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object v = this.i.next().getValue();
                        return v;
                    }
                    finally {
                        this.j.next();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<K> iteratorKeys() {
            if (this.firstBullet == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            return new Iterator<K>(){
                Iterator<FrequencyEntry<K, V>> i;
                Iterator<K> j;
                {
                    this.i = FrequencyMap.this.firstBullet.iterator();
                    this.j = FrequencyMap.this.map.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public K next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object k = this.i.next().getKey();
                        return k;
                    }
                    finally {
                        this.j.next();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean containsKey(K key) {
            return this.map.containsKey(key);
        }

        @Override
        public V get(K key) {
            FrequencyEntry<K, V> entry = this.map.get(key);
            if (entry != null) {
                this.recordAccess(entry);
                return entry.getValue();
            }
            return null;
        }

        @Override
        public void dispose() {
            this.map.clear();
            this.firstBullet = null;
        }

        @Override
        public int getSize() {
            return this.map.size();
        }

        private void recordAccess(FrequencyEntry<K, V> entry) {
            FrequencyBullet<K, V> suggestedFirstBullet = entry.recordAccess();
            if (suggestedFirstBullet != null) {
                this.firstBullet = suggestedFirstBullet;
            }
        }

        private void removeEldestEntry() {
            FrequencyEntry eldest = this.firstBullet.firstEntry;
            this.firstBullet = ((FrequencyBullet)this.firstBullet).remove(eldest);
            this.map.remove(eldest.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedMap<K, V>
    extends LinkedHashMap<K, V>
    implements CacheHelper<K, V> {
        private final int maximumSize;

        public FixedMap(int maximumSize, boolean accessOrder) {
            super(16, 0.75f, accessOrder);
            this.maximumSize = maximumSize;
        }

        @Override
        public Iterator<V> iterator() {
            return super.values().iterator();
        }

        @Override
        public Iterator<K> iteratorKeys() {
            return super.keySet().iterator();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.getMaximumSize();
        }

        @Override
        public int getMaximumSize() {
            return this.maximumSize;
        }

        @Override
        public void dispose() {
            this.clear();
        }

        @Override
        public int getSize() {
            return this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CacheHelper<K, V>
    extends Iterable<V>,
    Disposable {
        public int getMaximumSize();

        public int getSize();

        public V put(K var1, V var2);

        public V get(K var1);

        public boolean containsKey(K var1);

        @Override
        public Iterator<V> iterator();

        public Iterator<K> iteratorKeys();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RemovalEntryPolicy {
        LeastRecentlyUsed,
        LeastFrequentlyUsed,
        OldestInsertion;

    }
}

