/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.JavascriptUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalUtil {
    public static final int INBOUND_INDEX_TYPE = 0;
    public static final int INBOUND_INDEX_VALUE = 1;
    private static final Log log = LogFactory.getLog(LocalUtil.class);

    private LocalUtil() {
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        for (Object object : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(separator);
            }
            if (object == null) continue;
            buffer.append(object);
        }
        return buffer.toString();
    }

    public static boolean isJavaIdentifier(String test) {
        if (test == null || test.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(test.charAt(0)) && test.charAt(0) != '_') {
            return false;
        }
        for (int i = 1; i < test.length(); ++i) {
            if (Character.isJavaIdentifierPart(test.charAt(i)) || test.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigitOrUnderline(String test) {
        if (test == null || test.length() == 0) {
            return false;
        }
        for (int i = 0; i < test.length(); ++i) {
            if (Character.isLetterOrDigit(test.charAt(i)) || test.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Class<?> c1, Class<?> c2) {
        if (c1 == Boolean.class || c1 == Boolean.TYPE) {
            return c2 == Boolean.class || c2 == Boolean.TYPE;
        }
        if (c1 == Byte.class || c1 == Byte.TYPE) {
            return c2 == Byte.class || c2 == Byte.TYPE;
        }
        if (c1 == Character.class || c1 == Character.TYPE) {
            return c2 == Character.class || c2 == Character.TYPE;
        }
        if (c1 == Short.class || c1 == Short.TYPE) {
            return c2 == Short.class || c2 == Short.TYPE;
        }
        if (c1 == Integer.class || c1 == Integer.TYPE) {
            return c2 == Integer.class || c2 == Integer.TYPE;
        }
        if (c1 == Long.class || c1 == Long.TYPE) {
            return c2 == Long.class || c2 == Long.TYPE;
        }
        if (c1 == Float.class || c1 == Float.TYPE) {
            return c2 == Float.class || c2 == Float.TYPE;
        }
        if (c1 == Double.class || c1 == Double.TYPE) {
            return c2 == Double.class || c2 == Double.TYPE;
        }
        if (c1 == Void.class || c1 == Void.TYPE) {
            return c2 == Void.class || c2 == Void.TYPE;
        }
        return false;
    }

    public static Class<?> getNonPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        return null;
    }

    public static void addNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
    }

    public static boolean isServletClass(Class<?> paramType) {
        return paramType == HttpServletRequest.class || paramType == HttpServletResponse.class || paramType == ServletConfig.class || paramType == ServletContext.class || paramType == HttpSession.class;
    }

    public static String decode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"UTF-8 is not a valid char sequence?", (Throwable)ex);
            return value;
        }
    }

    public static void setParams(Object object, Map<String, ?> params, List<String> ignore) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(object, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (ignore == null || ignore.contains(key)) continue;
                log.warn((Object)("No property '" + key + "' on " + object.getClass().getName()));
            }
            catch (InvocationTargetException ex) {
                log.warn((Object)("Error setting " + key + "=" + value + " on " + object.getClass().getName()), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn((Object)("Error setting " + key + "=" + value + " on " + object.getClass().getName()), (Throwable)ex);
            }
        }
    }

    public static void setProperty(Object object, String key, Object value) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> real = object.getClass();
        String setterName = "set" + key.substring(0, 1).toUpperCase(Locale.ENGLISH) + key.substring(1);
        try {
            Method method = real.getMethod(setterName, value.getClass());
            method.invoke(object, value);
            return;
        }
        catch (NoSuchMethodException ex) {
            if (!(value instanceof String)) {
                throw ex;
            }
            for (Method setter : real.getMethods()) {
                if (!setter.getName().equals(setterName) || setter.getParameterTypes().length != 1) continue;
                Class<?> propertyType = setter.getParameterTypes()[0];
                try {
                    Object param = LocalUtil.simpleConvert((String)value, propertyType);
                    setter.invoke(object, param);
                    return;
                }
                catch (IllegalArgumentException ex2) {
                    // empty catch block
                }
            }
            throw new NoSuchMethodException("Failed to find a property called: " + key + " on " + object.getClass().getName());
        }
    }

    public static boolean isTypeSimplyConvertable(Class<?> paramType) {
        return paramType == String.class || paramType == Integer.class || paramType == Integer.TYPE || paramType == Short.class || paramType == Short.TYPE || paramType == Byte.class || paramType == Byte.TYPE || paramType == Long.class || paramType == Long.TYPE || paramType == Float.class || paramType == Float.TYPE || paramType == Double.class || paramType == Double.TYPE || paramType == Character.class || paramType == Character.TYPE || paramType == Boolean.class || paramType == Boolean.TYPE;
    }

    public static <T> T simpleConvert(String value, Class<T> paramType) {
        if (paramType == String.class) {
            return (T)value;
        }
        if (paramType == Character.class || paramType == Character.TYPE) {
            if ((value = LocalUtil.decode(value)).length() == 1) {
                return (T)Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException("Can't more than one character in string - can't convert to char: '" + value + "'");
        }
        String trimValue = value.trim();
        if (paramType == Boolean.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Boolean.valueOf(trimValue);
        }
        if (paramType == Boolean.TYPE) {
            return (T)Boolean.valueOf(trimValue);
        }
        if (paramType == Integer.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Integer.valueOf(trimValue);
        }
        if (paramType == Integer.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Integer.valueOf(0);
            }
            return (T)Integer.valueOf(trimValue);
        }
        if (paramType == Short.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Short.valueOf(trimValue);
        }
        if (paramType == Short.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Short.valueOf((short)0);
            }
            return (T)Short.valueOf(trimValue);
        }
        if (paramType == Byte.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Byte.valueOf(trimValue);
        }
        if (paramType == Byte.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Byte.valueOf((byte)0);
            }
            return (T)Byte.valueOf(trimValue);
        }
        if (paramType == Long.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Long.valueOf(trimValue);
        }
        if (paramType == Long.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Long.valueOf(0L);
            }
            return (T)Long.valueOf(trimValue);
        }
        if (paramType == Float.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Float.valueOf(trimValue);
        }
        if (paramType == Float.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Float.valueOf(0.0f);
            }
            return (T)Float.valueOf(trimValue);
        }
        if (paramType == Double.class) {
            if (trimValue.length() == 0) {
                return null;
            }
            return (T)Double.valueOf(trimValue);
        }
        if (paramType == Double.TYPE) {
            if (trimValue.length() == 0) {
                return (T)Double.valueOf(0.0);
            }
            return (T)Double.valueOf(trimValue);
        }
        throw new IllegalArgumentException("Unsupported conversion type: " + paramType.getName());
    }

    public static boolean isSimpleName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (JavascriptUtil.isReservedWord(name)) {
            return false;
        }
        boolean isSimple = Character.isLetter(name.charAt(0));
        for (int i = 1; isSimple && i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            isSimple = false;
        }
        return isSimple;
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public static Object invoke(Object object, Method method, Object[] params) throws IllegalStateException {
        Object reply = null;
        if (method != null) {
            try {
                reply = method.invoke(object, params);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException("InvocationTargetException calling " + method.getName() + ": " + ex.getTargetException().toString());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Reflection error calling " + method.getName() + ": " + ex.toString());
            }
        }
        return reply;
    }

    public static <T> Class<? extends T> classForName(String debugContext, String className, Class<T> impl) {
        Class<?> clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            log.debug((Object)"Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error((Object)("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'."));
            return null;
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)("InstantiationException for '" + debugContext + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("IllegalAccessException for '" + debugContext + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + debugContext + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            log.debug((Object)"Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof ClassNotFoundException) {
                log.debug((Object)("Skipping '" + debugContext + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
                return null;
            }
            log.error((Object)("Failed to load '" + debugContext + "' (" + className + ")"), (Throwable)ex);
            return null;
        }
        return clazz;
    }

    public static <T> T classNewInstance(String name, String className, Class<T> impl) {
        Class<?> clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)("Skipping '" + name + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug((Object)("Skipping '" + name + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug((Object)("Skipping '" + name + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage()));
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error((Object)("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'."));
            return null;
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)("InstantiationException for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("IllegalAccessException for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.error((Object)("TransformerFactoryConfigurationError for '" + name + "' failed:"), (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            log.error((Object)("Failed to load creator '" + name + "', classname=" + className + ": "), (Throwable)ex);
            return null;
        }
    }

    public static void close(Closeable in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Field[] getAllFields(Class<?> clazz) {
        List<Class<?>> classes = LocalUtil.getAllSuperclasses(clazz);
        classes.add(clazz);
        return LocalUtil.getAllFields(classes);
    }

    private static Field[] getAllFields(List<Class<?>> classes) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> clazz : classes) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }
}

