/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.impl.ContainerMap;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.directwebremoting.util.FakeServletConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrController
extends AbstractController
implements BeanNameAware,
InitializingBean,
BeanFactoryAware {
    private String name;
    private boolean debug = false;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private SpringContainer container;
    private ServletConfig servletConfig;
    private boolean includeDefaultConfig = true;
    private List<Configurator> configurators;
    private Map<String, String> configParams = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(DwrController.class);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.container = new SpringContainer();
        this.container.setBeanFactory(beanFactory);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void afterPropertiesSet() throws Exception {
        block12: {
            ApplicationContext parent = this.getApplicationContext().getParent();
            if (parent != null) {
                try {
                    Object parentConfigurator = parent.getBean("__dwrConfiguration");
                    if (parentConfigurator != null && !this.configurators.contains(parentConfigurator)) {
                        this.configurators.add((Configurator)parentConfigurator);
                    }
                }
                catch (RuntimeException rex) {
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)"Could not detect dwr configuration in parent context");
                }
            }
        }
        ServletContext servletContext = this.getServletContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("afterPropertiesSet() called with servletContext '" + servletContext + "'"));
        }
        Assert.notNull((Object)servletContext, (String)"The servlet context has not been set on the controller");
        Assert.notNull(this.configurators, (String)"The required 'configurators' property should be set");
        ContainerMap containerMap = new ContainerMap(this.container, true);
        for (Map.Entry<String, Object> entry : containerMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            this.configParams.put(entry.getKey(), (String)value);
        }
        this.configParams.put("debug", "" + this.debug);
        this.servletConfig = new FakeServletConfig(this.name, servletContext, this.configParams);
        try {
            ContainerUtil.setupDefaultContainer(this.container, this.servletConfig);
            StartupUtil.initContainerBeans(this.servletConfig, servletContext, this.container);
            this.webContextBuilder = this.container.getBean(WebContextFactory.WebContextBuilder.class);
            ContainerUtil.prepareForWebContextFilter(servletContext, this.servletConfig, this.container, this.webContextBuilder, null);
            ContainerUtil.publishContainer(this.container, this.servletConfig);
            if (this.includeDefaultConfig) {
                ContainerUtil.configureFromSystemDwrXml(this.container);
            }
            ContainerUtil.configure(this.container, this.configurators);
        }
        catch (Exception ex) {
            log.fatal((Object)"init failed", (Throwable)ex);
            throw ex;
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.webContextBuilder.set(request, response, this.servletConfig, this.getServletContext(), this.container);
            UrlProcessor processor = this.container.getBean(UrlProcessor.class);
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
        return null;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setConfigParams(Map<String, String> configParams) {
        Assert.notNull(configParams, (String)"configParams cannot be null");
        this.configParams = configParams;
    }
}

