/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.annotations.RemoteMethod;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.spring.BeanCreator;
import org.directwebremoting.spring.CreatorConfig;
import org.directwebremoting.spring.DwrNamespaceHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrAnnotationPostProcessor
implements BeanFactoryPostProcessor {
    protected static final Log log = LogFactory.getLog(DwrAnnotationPostProcessor.class);

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : beanDefinitionRegistry.getBeanDefinitionNames()) {
            RemoteProxy annotation;
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinitionRegistry.getBeanDefinition(beanName), beanName);
            Class<?> beanDefinitionClass = this.getBeanDefinitionClass(beanDefinitionHolder, beanDefinitionRegistry);
            if (beanDefinitionClass == null || (annotation = beanDefinitionClass.getAnnotation(RemoteProxy.class)) == null) continue;
            String javascript = annotation.name();
            if (log.isInfoEnabled()) {
                log.info((Object)("Detected candidate bean [" + beanName + "]. Remoting using " + javascript));
            }
            this.registerCreator(beanDefinitionHolder, beanDefinitionRegistry, beanDefinitionClass, javascript);
        }
    }

    protected Class<?> getBeanDefinitionClass(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        try {
            String beanClassName = DwrNamespaceHandler.resolveBeanClassname(beanDefinitionHolder.getBeanDefinition(), beanDefinitionRegistry);
            return ClassUtils.forName((String)beanClassName);
        }
        catch (Exception cne) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Could not infer class for [" + beanDefinitionHolder.getBeanName() + "]. Is it a factory bean? Omitting bean from annotation processing"));
            }
            return null;
        }
    }

    protected void registerCreator(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry, Class<?> beanDefinitionClass, String javascript) {
        BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition(BeanCreator.class);
        try {
            beanCreator.addPropertyValue("beanClass", beanDefinitionClass);
            String name = beanDefinitionHolder.getBeanName();
            if (name.startsWith("scopedTarget.")) {
                name = name.substring(name.indexOf(".") + 1);
            }
            beanCreator.addPropertyValue("beanId", (Object)name);
            beanCreator.addDependsOn(name);
            String creatorConfigName = "__" + javascript;
            beanCreator.addPropertyValue("javascript", (Object)javascript);
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition(CreatorConfig.class);
            creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
            ArrayList<String> includes = new ArrayList<String>();
            for (Method method : beanDefinitionClass.getMethods()) {
                if (method.getAnnotation(RemoteMethod.class) == null) continue;
                includes.add(method.getName());
            }
            creatorConfig.addPropertyValue("includes", includes);
            BeanDefinitionHolder aux = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)aux, (BeanDefinitionRegistry)beanDefinitionRegistry);
            DwrNamespaceHandler.lookupCreators(beanDefinitionRegistry).put(javascript, new RuntimeBeanReference(creatorConfigName));
        }
        catch (Exception ex) {
            throw new FatalBeanException("Unable to create DWR bean creator for '" + beanDefinitionHolder.getBeanName() + "'. ", (Throwable)ex);
        }
    }
}

