/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.util.CopyUtils;

public abstract class CachingFileHandler
implements Handler {
    private static final long CONTAINER_START_TIME;
    private static final String ETAG;
    private String mimeType;
    private final Map<String, String> scriptCache = new HashMap<String, String>();
    private boolean ignoreLastModified = false;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output;
        if (this.isUpToDate(request)) {
            response.setStatus(304);
            return;
        }
        Map<String, String> map = this.scriptCache;
        synchronized (map) {
            String url = request.getPathInfo();
            output = this.scriptCache.get(url);
            if (output == null) {
                output = this.generateCachableContent(request, response);
            }
            this.scriptCache.put(url, output);
        }
        response.setContentType(this.mimeType);
        response.setDateHeader("Last-Modified", CONTAINER_START_TIME);
        response.setHeader("ETag", ETAG);
        PrintWriter out = response.getWriter();
        out.println(output);
    }

    protected abstract String generateCachableContent(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected String readResource(String resource) throws IOException {
        InputStream raw = this.getClass().getResourceAsStream(resource);
        if (raw == null) {
            throw new IOException("Failed to find resource: " + resource);
        }
        StringWriter sw = new StringWriter();
        CopyUtils.copy(raw, (Writer)sw);
        return sw.toString();
    }

    protected boolean isUpToDate(HttpServletRequest req) {
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        String givenEtag = req.getHeader("If-None-Match");
        String pathInfo = req.getPathInfo();
        if (givenEtag == null) {
            if (modifiedSince > CONTAINER_START_TIME) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + pathInfo + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + CONTAINER_START_TIME));
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!ETAG.equals(givenEtag)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending 304 for " + pathInfo + ", If-Modified-Since=-1, Old ETag=" + givenEtag + ", New ETag=" + ETAG));
                }
                return true;
            }
            return false;
        }
        if (ETAG.equals(givenEtag) && modifiedSince < CONTAINER_START_TIME) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending 304 for " + pathInfo + ", If-Modified-Since=" + modifiedSince + ", Container Start=" + CONTAINER_START_TIME + ", Old ETag=" + givenEtag + ", New ETag=" + ETAG));
            }
            return true;
        }
        log.debug((Object)("Sending content for " + pathInfo + ", If-Modified-Since=" + modifiedSince + ", Container Start=" + CONTAINER_START_TIME + ", Old ETag=" + givenEtag + ", New ETag=" + ETAG));
        return false;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    static {
        long now = System.currentTimeMillis();
        CONTAINER_START_TIME = now - now % 1000L;
        ETAG = "\"" + CONTAINER_START_TIME + '\"';
        log = LogFactory.getLog(CachingFileHandler.class);
    }
}

