/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jms;

import java.util.Date;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.servlet.ServletContext;
import org.directwebremoting.Hub;
import org.directwebremoting.HubFactory;
import org.directwebremoting.jms.DwrConnection;
import org.directwebremoting.jms.DwrTopic;
import org.directwebremoting.jms.State;
import org.directwebremoting.jms.Unsupported;

public class DwrMessageProducer
implements MessageProducer {
    private Hub hub;
    private Destination destination;
    private int deliveryMode;
    private State state;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;

    public DwrMessageProducer(Destination destination, DwrConnection connection) {
        this.destination = destination;
        ServletContext servletContext = connection.getServletContext();
        this.hub = servletContext != null ? HubFactory.get(servletContext) : HubFactory.get();
    }

    public void close() throws JMSException {
        this.state = State.CLOSED;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    public void send(Message message) throws JMSException {
        this.send(this.destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination realDestination, Message message) throws JMSException {
        this.send(realDestination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int realDeliveryMode, int realPriority, long realTimeToLive) throws JMSException {
        this.send(this.destination, message, realDeliveryMode, realPriority, realTimeToLive);
    }

    public void send(Destination realDestination, Message message, int realDeliveryMode, int realPriority, long realTimeToLive) throws JMSException {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("DwrMessageProducer has been closed");
        }
        if (!this.disableMessageID) {
            message.setJMSMessageID(UUID.randomUUID().toString());
        }
        if (!this.disableMessageTimestamp) {
            message.setJMSTimestamp(new Date().getTime());
        }
        if (!(realDestination instanceof DwrTopic)) {
            throw new IllegalStateException("Unsuported Destination type (" + realDestination.getClass().getCanonicalName() + "). Only Topics are currently supported.");
        }
        DwrTopic dwrtopic = (DwrTopic)realDestination;
        String topicName = dwrtopic.getTopicName();
        this.hub.publish(topicName, message);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
        throw Unsupported.noManualAcknowledgment();
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.disableMessageID = disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void setPriority(int priority) throws JMSException {
        this.priority = priority;
        throw Unsupported.noMessagePriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.timeToLive = timeToLive;
        throw Unsupported.noMessageExpiry();
    }
}

