/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDescriptorProperty
implements Property {
    protected PropertyDescriptor descriptor;

    public PropertyDescriptorProperty(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Class<?> getPropertyType() {
        return this.descriptor.getPropertyType();
    }

    @Override
    public Object getValue(Object bean) throws MarshallException {
        try {
            return this.descriptor.getReadMethod().invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new MarshallException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new MarshallException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public void setValue(Object bean, Object value) throws MarshallException {
        try {
            this.descriptor.getWriteMethod().invoke(bean, value);
        }
        catch (InvocationTargetException ex) {
            throw new MarshallException(bean.getClass(), ex.getTargetException());
        }
        catch (Exception ex) {
            throw new MarshallException(bean.getClass(), (Throwable)ex);
        }
    }

    @Override
    public Method getSetter() {
        return this.descriptor.getWriteMethod();
    }
}

