/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.Alarm;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.BasicAlarm;
import org.directwebremoting.util.SharedObjects;

public class OutputAlarm
extends BasicAlarm
implements Alarm {
    protected ScriptConduit conduit = null;
    protected int maxWaitAfterWrite;
    protected RealScriptSession scriptSession;
    protected static final Log log = LogFactory.getLog(OutputAlarm.class);
    protected ScheduledFuture<?> future;

    public OutputAlarm(RealScriptSession scriptSession, int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
        this.scriptSession = scriptSession;
        this.conduit = new AlarmScriptConduit();
    }

    public void setAlarmAction(Sleeper sleeper) {
        try {
            this.scriptSession.addScriptConduit(this.conduit);
        }
        catch (IOException ex) {
            log.warn((Object)"Error adding monitor to script session", (Throwable)ex);
        }
        super.setAlarmAction(sleeper);
    }

    public void cancel() {
        this.scriptSession.removeScriptConduit(this.conduit);
        if (this.future != null) {
            this.future.cancel(false);
        }
        super.cancel();
    }

    protected class AlarmScriptConduit
    extends ScriptConduit {
        protected AlarmScriptConduit() {
            super(10);
        }

        public boolean addScript(ScriptBuffer script) {
            if (OutputAlarm.this.maxWaitAfterWrite == 0) {
                OutputAlarm.this.raiseAlarm();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        OutputAlarm.this.raiseAlarm();
                    }
                };
                ScheduledThreadPoolExecutor executor = SharedObjects.getScheduledThreadPoolExecutor();
                OutputAlarm.this.future = executor.schedule(runnable, (long)OutputAlarm.this.maxWaitAfterWrite, TimeUnit.MILLISECONDS);
            }
            return false;
        }
    }
}

