/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.DefaultServerContext;

public class DefaultServerContextBuilder
implements ServerContextFactory.ServerContextBuilder {
    private static final String ATTRIBUTE_SERVER_CONTEXT = "org.directwebremoting.impl.ServerContext";
    private static final Log log = LogFactory.getLog(DefaultServerContextBuilder.class);

    public void set(ServletConfig config, ServletContext context, Container container) {
        try {
            DefaultServerContext ec = new DefaultServerContext(config, context, container);
            context.setAttribute(ATTRIBUTE_SERVER_CONTEXT, (Object)ec);
        }
        catch (Exception ex) {
            log.fatal((Object)"Failed to create an ExecutionContext", (Throwable)ex);
        }
    }

    public ServerContext get(ServletContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        ServerContext reply = (ServerContext)context.getAttribute(ATTRIBUTE_SERVER_CONTEXT);
        if (reply == null) {
            log.warn((Object)"ServerContextFactory.get(ServletContext) returns null when DWR has not been initialized in the given ServletContext");
        }
        return reply;
    }

    public ServerContext get() {
        ServerContext serverContext = ContainerUtil.getSingletonServerContext();
        if (serverContext == null) {
            log.fatal((Object)"Error initializing Hub because singleton ServerContext == null.");
            log.fatal((Object)"This probably means that either DWR has not been properly initialized (in which case you should delay the current action until it has)");
            log.fatal((Object)"or that there is more than 1 DWR servlet is configured in this classloader, in which case you should provide a ServletContext to the Hub yourself.");
            throw new IllegalStateException("No singleton ServerContext see logs for possible causes and solutions.");
        }
        return serverContext;
    }
}

