/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;

public class DefaultRemoter
implements Remoter {
    private boolean debug = false;
    private AjaxFilterManager ajaxFilterManager = null;
    protected CreatorManager creatorManager = null;
    protected ConverterManager converterManager = null;
    protected AccessControl accessControl = null;
    protected String overridePath = null;
    protected boolean allowImpossibleTests = false;
    protected int maxCallCount = 20;
    protected Map<String, String> methodCache = Collections.synchronizedMap(new HashMap());
    private static final Log log = LogFactory.getLog(DefaultRemoter.class);

    public String generateInterfaceScript(String scriptName, String path) throws SecurityException {
        String actualPath = path;
        if (this.overridePath != null) {
            actualPath = this.overridePath;
        }
        Creator creator = this.creatorManager.getCreator(scriptName);
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.createParameterDefinitions());
        buffer.append(EnginePrivate.getEngineInitScript());
        buffer.append(this.createClassDefinition(scriptName));
        buffer.append(this.createPathDefinition(scriptName, actualPath));
        buffer.append(this.createMethodDefinitions(creator, scriptName));
        return buffer.toString();
    }

    protected String createClassDefinition(String scriptName) {
        return "if (typeof this['" + scriptName + "'] == 'undefined') this." + scriptName + " = {};\n\n";
    }

    protected String createPathDefinition(String scriptName, String actualPath) {
        return scriptName + "._path = '" + actualPath + "';\n\n";
    }

    protected String createMethodDefinitions(Creator creator, String scriptName) {
        Method[] methods;
        StringBuilder buffer = new StringBuilder();
        for (Method method : methods = creator.getType().getMethods()) {
            String script;
            String methodName = method.getName();
            try {
                this.accessControl.assertIsDisplayable(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                if (!this.allowImpossibleTests) continue;
            }
            if (JavascriptUtil.isReservedWord(methodName)) continue;
            if (!creator.isCacheable()) {
                script = this.getMethodJS(scriptName, method);
            } else {
                String key = scriptName + "." + method.getName();
                script = this.methodCache.get(key);
                if (script == null) {
                    script = this.getMethodJS(scriptName, method);
                    this.methodCache.put(key, script);
                }
            }
            buffer.append(script);
        }
        return buffer.toString();
    }

    protected String createParameterDefinitions() {
        StringBuilder buffer = new StringBuilder();
        for (String match : this.converterManager.getConverterMatchStrings()) {
            try {
                NamedConverter boConv;
                String jsClassName;
                StringBuilder paramBuffer = new StringBuilder();
                Converter conv = this.converterManager.getConverterByMatchString(match);
                if (conv instanceof NamedConverter && (jsClassName = (boConv = (NamedConverter)conv).getJavascript()) != null && !"".equals(jsClassName) && !match.contains("*")) {
                    Class<?> mappedType;
                    paramBuffer.append('\n');
                    paramBuffer.append("if (typeof this['" + jsClassName + "'] != 'function') {\n");
                    paramBuffer.append("  function " + jsClassName + "() {\n");
                    try {
                        mappedType = LocalUtil.classForName(match);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new IllegalArgumentException(ex.getMessage());
                    }
                    Map<String, Property> properties = boConv.getPropertyMapFromClass(mappedType, true, true);
                    for (Map.Entry<String, Property> entry : properties.entrySet()) {
                        String name = entry.getKey();
                        Property property = entry.getValue();
                        Class<?> propType = property.getPropertyType();
                        paramBuffer.append("    this." + name + " = ");
                        if (propType.isArray()) {
                            paramBuffer.append("[]");
                        } else if (propType == Boolean.TYPE) {
                            paramBuffer.append("false");
                        } else if (propType.isPrimitive()) {
                            paramBuffer.append("0");
                        } else {
                            paramBuffer.append("null");
                        }
                        paramBuffer.append(";\n");
                    }
                    paramBuffer.append("  }\n");
                    paramBuffer.append("}\n");
                }
                buffer.append(paramBuffer.toString());
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to create parameter declaration for " + match), (Throwable)ex);
                buffer.append("// Missing parameter declaration for " + match + ". See the server logs for details.");
            }
        }
        buffer.append('\n');
        return buffer.toString();
    }

    protected String getMethodJS(String scriptName, Method method) {
        StringBuffer buffer = new StringBuffer();
        String methodName = method.getName();
        buffer.append(scriptName + '.' + methodName + " = function(");
        Class<?>[] paramTypes = method.getParameterTypes();
        for (int j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) continue;
            buffer.append("p" + j + ", ");
        }
        buffer.append("callback) {\n");
        String executeFunctionName = EnginePrivate.getExecuteFunctionName();
        buffer.append("  " + executeFunctionName + "(" + scriptName + "._path, '" + scriptName + "', '" + methodName + "', ");
        for (int j = 0; j < paramTypes.length; ++j) {
            if (LocalUtil.isServletClass(paramTypes[j])) {
                buffer.append("false, ");
                continue;
            }
            buffer.append("p" + j + ", ");
        }
        buffer.append("callback);\n");
        buffer.append("};\n\n");
        return buffer.toString();
    }

    public Replies execute(Calls calls) {
        Replies replies = new Replies(calls.getBatchId());
        int callCount = calls.getCallCount();
        if (callCount > this.maxCallCount) {
            log.error((Object)"Call count for batch exceeds maxCallCount. Add an init-param of maxCallCount to increase this limit");
            throw new SecurityException("Call count for batch is too high");
        }
        for (Call call : calls) {
            Reply reply = this.execute(call);
            replies.addReply(reply);
        }
        return replies;
    }

    public Reply execute(Call call) {
        try {
            Method method = call.getMethod();
            if (method == null || call.getException() != null) {
                return new Reply(call.getCallId(), null, call.getException());
            }
            Creator creator = this.creatorManager.getCreator(call.getScriptName());
            this.accessControl.assertExecutionIsPossible(creator, call.getScriptName(), method);
            Object object = null;
            String scope = creator.getScope();
            boolean create = false;
            if (!Modifier.isStatic(method.getModifiers())) {
                WebContext webcx = WebContextFactory.get();
                if (scope.equals("application")) {
                    object = webcx.getServletContext().getAttribute(call.getScriptName());
                } else if (scope.equals("session")) {
                    object = webcx.getSession().getAttribute(call.getScriptName());
                } else if (scope.equals("script")) {
                    object = webcx.getScriptSession().getAttribute(call.getScriptName());
                } else if (scope.equals("request")) {
                    object = webcx.getHttpServletRequest().getAttribute(call.getScriptName());
                }
                if (object == null) {
                    create = true;
                    object = creator.getInstance();
                }
                if (create) {
                    if (scope.equals("application")) {
                        webcx.getServletContext().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("session")) {
                        webcx.getSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("script")) {
                        webcx.getScriptSession().setAttribute(call.getScriptName(), object);
                    } else if (scope.equals("request")) {
                        webcx.getHttpServletRequest().setAttribute(call.getScriptName(), object);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Exec: ").append(call.getScriptName()).append(".").append(call.getMethodName()).append("()");
                if (create) {
                    buffer.append(" Object created, ");
                    if (!scope.equals("page")) {
                        buffer.append(" stored in ");
                        buffer.append(scope);
                    } else {
                        buffer.append(" not stored");
                    }
                } else {
                    buffer.append(" Object found in ");
                    buffer.append(scope);
                }
                buffer.append(". ");
                buffer.append("id=");
                buffer.append(call.getCallId());
                log.debug((Object)buffer.toString());
            }
            final Iterator<AjaxFilter> it = this.ajaxFilterManager.getAjaxFilters(call.getScriptName());
            AjaxFilterChain chain = new AjaxFilterChain(){

                public Object doFilter(Object obj, Method meth, Object[] p) throws Exception {
                    AjaxFilter next = (AjaxFilter)it.next();
                    return next.doFilter(obj, meth, p, this);
                }
            };
            Object reply = chain.doFilter(object, method, call.getParameters());
            return new Reply(call.getCallId(), reply);
        }
        catch (SecurityException ex) {
            log.debug((Object)"Security Exception: ", (Throwable)ex);
            if (this.debug) {
                return new Reply(call.getCallId(), null, ex);
            }
            return new Reply(call.getCallId(), null, new SecurityException());
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowIfContinuation(ex);
            log.debug((Object)"Method execution failed: ", ex.getTargetException());
            return new Reply(call.getCallId(), null, ex.getTargetException());
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            log.debug((Object)"Method execution failed: ", (Throwable)ex);
            return new Reply(call.getCallId(), null, ex);
        }
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAjaxFilterManager(AjaxFilterManager ajaxFilterManager) {
        this.ajaxFilterManager = ajaxFilterManager;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setMaxCallCount(int maxCallCount) {
        this.maxCallCount = maxCallCount;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

