/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.Hub;
import org.directwebremoting.event.MessageEvent;
import org.directwebremoting.event.MessageListener;

public class DefaultHub
implements Hub {
    private final Map<String, Set<MessageListener>> subscriptions = new HashMap<String, Set<MessageListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topicName, MessageListener listener) {
        Map<String, Set<MessageListener>> map = this.subscriptions;
        synchronized (map) {
            Set<MessageListener> listeners = this.subscriptions.get(topicName);
            if (listeners == null) {
                listeners = new HashSet<MessageListener>();
                this.subscriptions.put(topicName, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String topicName, MessageListener listener) {
        Map<String, Set<MessageListener>> map = this.subscriptions;
        synchronized (map) {
            boolean unsubscribed = false;
            Set<MessageListener> listeners = this.subscriptions.get(topicName);
            if (listeners != null) {
                unsubscribed = listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.subscriptions.remove(topicName);
                }
            }
            return unsubscribed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topicName, Object data) {
        HashSet<MessageListener> listeners;
        Map<String, Set<MessageListener>> map = this.subscriptions;
        synchronized (map) {
            Set<MessageListener> current = this.subscriptions.get(topicName);
            if (current == null) {
                return;
            }
            listeners = new HashSet<MessageListener>();
            listeners.addAll(current);
        }
        for (MessageListener listener : listeners) {
            MessageEvent event = data instanceof MessageEvent ? (MessageEvent)data : new MessageEvent(this, data);
            listener.onMessage(event);
        }
    }
}

