/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.DebugPageGenerator;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDebugPageGenerator
implements DebugPageGenerator {
    protected String engineHandlerUrl;
    protected String utilHandlerUrl;
    protected String testHandlerUrl;
    protected String interfaceHandlerUrl;
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    protected final Map<String, String> scriptCache = new HashMap<String, String>();
    private Collection<String> availableLibraries = null;
    private static final String PATH_UP = "..";
    private static final Log log = LogFactory.getLog(DefaultDebugPageGenerator.class);

    @Override
    public String generateIndexPage(String root) throws SecurityException {
        if (!this.creatorManager.isDebug()) {
            log.warn((Object)"Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            throw new SecurityException(Messages.getString("DefaultDebugPageGenerator.AccessDenied"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<head><title>DWR Test Index</title></head>\n");
        buffer.append("<body>\n");
        buffer.append("<h2>Classes known to DWR:</h2>\n");
        buffer.append("<ul>\n");
        for (String name : this.creatorManager.getCreatorNames()) {
            Creator creator = this.creatorManager.getCreator(name);
            buffer.append("<li><a href='");
            buffer.append(root);
            buffer.append(this.testHandlerUrl);
            buffer.append(name);
            buffer.append("'>");
            buffer.append(name);
            buffer.append("</a> (");
            buffer.append(creator.getType().getName());
            buffer.append(")</li>\n");
        }
        buffer.append("</ul>\n");
        buffer.append("</body></html>\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateTestPage(String root, String scriptName) throws SecurityException {
        if (!this.creatorManager.isDebug()) {
            log.warn((Object)"Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            throw new SecurityException(Messages.getString("DefaultAccessControl.AccessDenied"));
        }
        String interfaceURL = root + this.interfaceHandlerUrl + scriptName + ".js";
        String engineURL = root + this.engineHandlerUrl;
        String utilURL = root + this.utilHandlerUrl;
        String proxyInterfaceURL = PATH_UP + this.interfaceHandlerUrl + scriptName + ".js";
        String proxyEngineURL = PATH_UP + this.engineHandlerUrl;
        String proxyUtilURL = PATH_UP + this.utilHandlerUrl;
        Creator creator = this.creatorManager.getCreator(scriptName);
        Method[] methods = creator.getType().getMethods();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<head>\n");
        buffer.append("  <title>DWR Test</title>\n");
        buffer.append("  <!-- These paths use .. so that they still work behind a path mapping proxy. The fully qualified version is more cut and paste friendly. -->\n");
        buffer.append("  <script type='text/javascript' src='" + proxyInterfaceURL + "'></script>\n");
        buffer.append("  <script type='text/javascript' src='" + proxyEngineURL + "'></script>\n");
        buffer.append("  <script type='text/javascript' src='" + proxyUtilURL + "'></script>\n");
        buffer.append("  <script type='text/javascript'>\n");
        buffer.append("  function objectEval(text)\n");
        buffer.append("  {\n");
        buffer.append("    // eval() breaks when we use it to get an object using the { a:42, b:'x' }\n");
        buffer.append("    // syntax because it thinks that { and } surround a block and not an object\n");
        buffer.append("    // So we wrap it in an array and extract the first element to get around\n");
        buffer.append("    // this.\n");
        buffer.append("    // This code is only needed for interpreting the parameter input fields,\n");
        buffer.append("    // so you can ignore this for normal use.\n");
        buffer.append("    // The regex = [start of line][whitespace]{[stuff]}[whitespace][end of line]\n");
        buffer.append("    text = text.replace(/\\n/g, ' ');\n");
        buffer.append("    text = text.replace(/\\r/g, ' ');\n");
        buffer.append("    if (text.match(/^\\s*\\{.*\\}\\s*$/))\n");
        buffer.append("    {\n");
        buffer.append("      text = '[' + text + '][0]';\n");
        buffer.append("    }\n");
        buffer.append("    return eval(text);\n");
        buffer.append("  }\n");
        buffer.append("  </script>\n");
        buffer.append("  <style>\n");
        buffer.append("    input.itext { font-size: smaller; background: #E4E4E4; border: 0; }\n");
        buffer.append("    input.ibutton { font-size: xx-small; border: 1px outset; margin: 0px; padding: 0px; }\n");
        buffer.append("    span.reply { background: #ffffdd; white-space: pre; }\n");
        buffer.append("    span.warning { font-size: smaller; color: red; }\n");
        buffer.append("  </style>\n");
        buffer.append("</head>\n");
        buffer.append("<body onload='dwr.util.useLoadingMessage()'>\n");
        buffer.append("<h2>Methods For: " + scriptName + " (" + creator.getType().getName() + ")</h2>\n");
        buffer.append("<p>To use this class in your javascript you will need the following script includes:</p>\n");
        buffer.append("<pre>\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + interfaceURL + "'>" + interfaceURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + engineURL + "'>" + engineURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("</pre>\n");
        buffer.append("<p>In addition there is an optional utility script:</p>\n");
        buffer.append("<pre>\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + utilURL + "'>" + utilURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("</pre>\n");
        buffer.append("<p>Replies from DWR are shown with a yellow background if they are simple or in an alert box otherwise.<br/>\n");
        buffer.append("The inputs are evaluated as Javascript so strings must be quoted before execution.</p>\n");
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (JavascriptUtil.isReservedWord(methodName)) {
                buffer.append("<li style='color: #88A;'>" + methodName + "() is not available because it is a reserved word.</li>\n");
                continue;
            }
            buffer.append("<li>\n");
            buffer.append("  " + methodName + '(');
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j = 0; j < paramTypes.length; ++j) {
                Class<?> paramType = paramTypes[j];
                if (LocalUtil.isServletClass(paramType)) {
                    buffer.append("AUTO");
                } else {
                    String value = "";
                    if (paramType == String.class) {
                        value = "\"\"";
                    } else if (paramType == Boolean.class || paramType == Boolean.TYPE) {
                        value = "true";
                    } else if (paramType == Integer.class || paramType == Integer.TYPE || paramType == Short.class || paramType == Short.TYPE || paramType == Long.class || paramType == Long.TYPE || paramType == Byte.class || paramType == Byte.TYPE) {
                        value = "0";
                    } else if (paramType == Float.class || paramType == Float.TYPE || paramType == Double.class || paramType == Double.TYPE) {
                        value = "0.0";
                    } else if (paramType.isArray() || Collection.class.isAssignableFrom(paramType)) {
                        value = "[]";
                    } else if (Map.class.isAssignableFrom(paramType)) {
                        value = "{}";
                    }
                    buffer.append("    <input class='itext' type='text' size='10' value='" + value + "' id='p" + i + j + "' title='Will be converted to: " + paramType.getName() + "'/>");
                }
                buffer.append(j == paramTypes.length - 1 ? "" : ", \n");
            }
            buffer.append("  );\n");
            String onclick = scriptName + '.' + methodName + "(";
            for (int j = 0; j < paramTypes.length; ++j) {
                if (LocalUtil.isServletClass(paramTypes[j])) continue;
                onclick = onclick + "objectEval($(\"p" + i + j + "\").value), ";
            }
            onclick = onclick + "reply" + i + ");";
            buffer.append("  <input class='ibutton' type='button' onclick='" + onclick + "' value='Execute'  title='Calls " + scriptName + '.' + methodName + "(). View source for details.'/>\n");
            buffer.append("  <script type='text/javascript'>\n");
            buffer.append("    var reply" + i + " = function(data)\n");
            buffer.append("    {\n");
            buffer.append("      if (data != null && typeof data == 'object') alert(dwr.util.toDescriptiveString(data, 2));\n");
            buffer.append("      else dwr.util.setValue('d" + i + "', dwr.util.toDescriptiveString(data, 1));\n");
            buffer.append("    }\n");
            buffer.append("  </script>\n");
            buffer.append("  <span id='d" + i + "' class='reply'></span>\n");
            boolean overloaded = false;
            for (int j = 0; j < methods.length; ++j) {
                if (j == i || !methods[j].getName().equals(methodName)) continue;
                overloaded = true;
            }
            if (overloaded) {
                buffer.append("<br/><span class='warning'>(Warning: overloaded methods are not recommended. See <a href='#overloadedMethod'>below</a>)</span>\n");
            }
            for (Class<?> paramType1 : paramTypes) {
                if (this.converterManager.isConvertable(paramType1)) continue;
                buffer.append("<br/><span class='warning'>(Warning: No Converter for " + paramType1.getName() + ". See <a href='#missingConverter'>below</a>)</span>\n");
            }
            if (!this.converterManager.isConvertable(method.getReturnType())) {
                buffer.append("<br/><span class='warning'>(Warning: No Converter for " + method.getReturnType().getName() + ". See <a href='#missingConverter'>below</a>)</span>\n");
            }
            try {
                this.accessControl.assertIsDisplayable(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                buffer.append("<br/><span class='warning'>(Warning: " + methodName + "() is excluded: " + ex.getMessage() + ". See <a href='#excludedMethod'>below</a>)</span>\n");
            }
            buffer.append("</li>\n");
        }
        buffer.append("</ul>\n");
        buffer.append("<h2>Other Links</h2>\n");
        buffer.append("<ul>\n");
        buffer.append("<li>Back to <a href='" + root + "/'>class index</a>.</li>\n");
        buffer.append("</ul>\n");
        Map<String, String> map = this.scriptCache;
        synchronized (map) {
            String output = this.scriptCache.get("/help.html");
            if (output == null) {
                InputStream raw = this.getClass().getResourceAsStream("/org/directwebremoting/help.html");
                if (raw == null) {
                    log.error((Object)Messages.getString("DefaultProcessor.MissingHelp", "/help.html"));
                    output = "<p>Failed to read help text from resource file. Check dwr.jar is built to include html files.</p>";
                } else {
                    StringBuffer fileBuffer = new StringBuffer();
                    BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            fileBuffer.append(line);
                            fileBuffer.append('\n');
                        }
                    }
                    catch (IOException ex) {
                        fileBuffer.append(ex.toString());
                        fileBuffer.append('\n');
                    }
                    output = fileBuffer.toString();
                }
                this.scriptCache.put("/help.html", output);
            }
            buffer.append(output);
        }
        buffer.append("</body></html>\n");
        return buffer.toString();
    }

    @Override
    @Deprecated
    public String generateInterfaceUrl(String root, String scriptName) {
        return root + this.interfaceHandlerUrl + scriptName + ".js";
    }

    @Override
    @Deprecated
    public String generateEngineUrl(String root) {
        return root + this.engineHandlerUrl;
    }

    @Override
    @Deprecated
    public String generateLibraryUrl(String root, String library) {
        return root + library;
    }

    @Override
    @Deprecated
    public Collection<String> getAvailableLibraries() {
        if (this.availableLibraries == null) {
            this.availableLibraries = Collections.unmodifiableCollection(Arrays.asList(this.utilHandlerUrl));
        }
        return this.availableLibraries;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setEngineHandlerUrl(String engineHandlerUrl) {
        this.engineHandlerUrl = engineHandlerUrl;
    }

    public void setUtilHandlerUrl(String utilHandlerUrl) {
        this.utilHandlerUrl = utilHandlerUrl;
    }

    public void setTestHandlerUrl(String testHandlerUrl) {
        this.testHandlerUrl = testHandlerUrl;
    }

    public void setInterfaceHandlerUrl(String interfaceHandlerUrl) {
        this.interfaceHandlerUrl = interfaceHandlerUrl;
    }
}

