/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.faces;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfCreator
extends AbstractCreator
implements Creator {
    private String managedBeanName;
    private Class<?> instanceType;
    private static final Log log = LogFactory.getLog(JsfCreator.class);

    @Override
    public Class<?> getType() {
        if (this.instanceType == null) {
            try {
                this.instanceType = this.getInstance().getClass();
            }
            catch (InstantiationException ex) {
                log.error((Object)"Failed to instansiate object to detect type.", (Throwable)ex);
                return Object.class;
            }
        }
        return this.instanceType;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            log.error((Object)("Object " + this.getManagedBeanName() + " cannot be created since the faces context is null"));
            return null;
        }
        Application application = facesContext.getApplication();
        Object resolvedObject = null;
        if (JsfCreator.isVBExpression(this.getManagedBeanName())) {
            ValueBinding vb = application.createValueBinding(this.getManagedBeanName());
            if (vb != null) {
                resolvedObject = vb.getValue(facesContext);
            }
        } else {
            VariableResolver resolver = application.getVariableResolver();
            resolvedObject = resolver.resolveVariable(facesContext, this.getManagedBeanName());
        }
        return resolvedObject;
    }

    public static boolean isVBExpression(String expression) {
        if (expression == null) {
            return false;
        }
        int start = expression.indexOf("#{");
        int end = expression.indexOf(125);
        return start != -1 && start < end;
    }

    public String getManagedBeanName() {
        return this.managedBeanName;
    }

    public void setManagedBeanName(String managedBeanName) {
        this.managedBeanName = managedBeanName;
    }

    public void setClass(String classname) {
        try {
            this.instanceType = LocalUtil.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Creator.ClassNotFound");
        }
    }
}

