/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Collection;
import org.directwebremoting.extend.JsonModeMarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NonJsonNestedOutboundVariable
implements OutboundVariable {
    private OutboundVariable reference;
    private boolean outline = false;
    private String declareCode;
    private String buildCode;
    private String assignCode;
    private String varName;
    protected Collection<OutboundVariable> children;
    private OutboundContext outboundContext;

    protected NonJsonNestedOutboundVariable(OutboundContext outboundContext) {
        this.outboundContext = outboundContext;
    }

    protected void forceOutline() {
        if (this.outboundContext.isJsonMode()) {
            throw new JsonModeMarshallException(NonJsonNestedOutboundVariable.class, "Outline in JSON mode is illegal");
        }
        this.outline = true;
    }

    public boolean isOutline() {
        return this.outline;
    }

    @Override
    public String getDeclareCode() {
        if (this.declareCode == null || this.children == null) {
            throw new NullPointerException();
        }
        return this.declareCode + this.getChildDeclareCodes();
    }

    public void setBaseDeclareCode(String declareCode) {
        this.declareCode = declareCode;
    }

    @Override
    public String getBuildCode() {
        if (this.declareCode == null || this.children == null) {
            throw new NullPointerException();
        }
        return this.buildCode + this.getChildBuildCodes();
    }

    public void setBaseBuildCode(String buildCode) {
        this.buildCode = buildCode;
    }

    @Override
    public String getAssignCode() {
        return this.assignCode;
    }

    public void setAssignCode(String assignCode) {
        this.assignCode = assignCode;
    }

    @Override
    public OutboundVariable getReferenceVariable() {
        if (this.reference == null) {
            this.reference = new NonNestedOutboundVariable(this.getVariableName());
            this.forceOutline();
        }
        return this.reference;
    }

    protected void prepareChildAssignCodes() {
        for (OutboundVariable child : this.children) {
            child.prepareAssignCode();
        }
    }

    private String getChildBuildCodes() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (OutboundVariable nested : this.children) {
            buffer.append(nested.getBuildCode());
        }
        return buffer.toString();
    }

    private String getChildDeclareCodes() {
        if (this.children == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (OutboundVariable nested : this.children) {
            buffer.append(nested.getDeclareCode());
        }
        return buffer.toString();
    }

    protected String getVariableName() {
        if (this.varName == null) {
            this.varName = this.outboundContext.getNextVariableName();
        }
        return this.varName;
    }

    public void setChildren(Collection<OutboundVariable> children) {
        this.children = children;
    }
}

