/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch {
    private List<InboundContext> inboundContexts = new ArrayList<InboundContext>();
    private int maxCallsPerBatch = 1000;
    private Calls calls;
    private String httpSessionId;
    private String page;
    private String windowName;
    private String scriptSessionId;
    private boolean get;
    private Map<String, FormField> allParameters;
    private Map<String, FormField> spareParameters = new HashMap<String, FormField>();
    protected static final Log log = LogFactory.getLog(Batch.class);

    public Batch(HttpServletRequest request) throws ServerException {
        this.get = "GET".equals(request.getMethod());
        ParseUtil parseUtil = new ParseUtil();
        this.allParameters = parseUtil.parseRequest(request);
        this.parseParameters();
    }

    public Batch(Map<String, FormField> allParameters) {
        this.allParameters = allParameters;
        this.parseParameters();
    }

    protected void parseParameters() {
        int callCount;
        HashMap<String, FormField> paramMap = new HashMap<String, FormField>(this.allParameters);
        this.calls = new Calls();
        String callStr = this.extractParameter(paramMap, "callCount");
        try {
            callCount = Integer.parseInt(callStr);
        }
        catch (NumberFormatException ex) {
            throw new SecurityException("Invalid Call Count");
        }
        if (callCount > this.maxCallsPerBatch) {
            throw new SecurityException("Too many calls in a batch");
        }
        for (int callNum = 0; callNum < callCount; ++callNum) {
            Call call = new Call();
            this.calls.addCall(call);
            InboundContext inctx = new InboundContext();
            this.inboundContexts.add(inctx);
            String prefix = "c" + callNum + "-";
            String callId = this.extractParameter(paramMap, prefix + "id");
            call.setCallId(callId);
            if (!LocalUtil.isLetterOrDigitOrUnderline(callId)) {
                throw new SecurityException("Call IDs may only contain Java Identifiers");
            }
            String scriptName = this.extractParameter(paramMap, prefix + "scriptName");
            call.setScriptName(scriptName);
            if (!LocalUtil.isLetterOrDigitOrUnderline(scriptName)) {
                throw new SecurityException("Script names may only contain Java Identifiers");
            }
            String methodName = this.extractParameter(paramMap, prefix + "methodName");
            call.setMethodName(methodName);
            if (!LocalUtil.isLetterOrDigitOrUnderline(methodName)) {
                throw new SecurityException("Method names may only contain Java Identifiers");
            }
            Iterator it = paramMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                FormField formField = (FormField)entry.getValue();
                if (formField.isFile()) {
                    inctx.createInboundVariable(callNum, key, "file", formField);
                } else {
                    String[] split = ParseUtil.splitInbound(formField.getString());
                    String value = split[1];
                    String type = split[0];
                    inctx.createInboundVariable(callNum, key, type, value);
                }
                it.remove();
            }
        }
        String batchId = this.extractParameter(paramMap, "batchId");
        this.calls.setBatchId(batchId);
        if (!LocalUtil.isLetterOrDigitOrUnderline(batchId)) {
            throw new SecurityException("Batch IDs may only contain Java Identifiers");
        }
        this.httpSessionId = this.extractParameter(paramMap, "httpSessionId");
        this.scriptSessionId = this.extractParameter(paramMap, "scriptSessionId");
        this.page = this.extractParameter(paramMap, "page");
        this.windowName = this.extractParameter(this.allParameters, "windowName");
        for (Map.Entry entry : paramMap.entrySet()) {
            String key = (String)entry.getKey();
            FormField value = (FormField)entry.getValue();
            if (!key.startsWith("p-")) continue;
            this.spareParameters.put(key.substring("p-".length()), value);
        }
    }

    protected String extractParameter(Map<String, FormField> parameters, String paramName) {
        FormField formField = parameters.remove(paramName);
        if (formField == null) {
            throw new IllegalArgumentException(Messages.getString("PollHandler.MissingParameter", paramName));
        }
        return formField.getString();
    }

    public List<InboundContext> getInboundContexts() {
        return this.inboundContexts;
    }

    public Map<String, FormField> getSpareParameters() {
        return this.spareParameters;
    }

    public Calls getCalls() {
        return this.calls;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public String getScriptSessionId() {
        return this.scriptSessionId;
    }

    public String getPage() {
        return this.page;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean isGet() {
        return this.get;
    }

    public String toString() {
        return "Batch[page=" + this.page + ",scriptSessionId=" + this.scriptSessionId + "]";
    }
}

